/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic.core;

import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSortUI {
    private RowSorter<? extends ListModel> sorter;
    private JXList list;
    private ListSelectionModel modelSelection;
    private int modelLeadIndex;
    private boolean syncingSelection;
    private int[] lastModelSelection;
    private boolean sorterChanged;
    private boolean ignoreSortChange;
    private RowSorterListener sorterListener;

    public ListSortUI(JXList list, RowSorter<? extends ListModel> sorter) {
        this.sorter = Contract.asNotNull(sorter, "RowSorter must not be null");
        this.list = Contract.asNotNull(list, "list must not be null");
        if (sorter != list.getRowSorter()) {
            throw new IllegalStateException("sorter must be same as the one on list");
        }
        this.sorterListener = this.createRowSorterListener();
        sorter.addRowSorterListener(this.sorterListener);
    }

    public void dispose() {
        if (this.sorter != null) {
            this.sorter.removeRowSorterListener(this.sorterListener);
        }
        this.sorter = null;
        this.list = null;
    }

    public void modelChanged(ListDataEvent e) {
        ModelChange change = new ModelChange(e);
        this.prepareForChange(change);
        this.notifySorter(change);
        if (change.type != 0) {
            this.sorterChanged = true;
        }
        this.processChange(change);
    }

    public void viewSelectionChanged(ListSelectionEvent e) {
        if (!this.syncingSelection && this.modelSelection != null) {
            this.modelSelection = null;
        }
    }

    protected void sortedChanged(RowSorterEvent e) {
        this.sorterChanged = true;
        if (!this.ignoreSortChange) {
            this.prepareForChange(e);
            this.processChange(null);
            this.list.revalidate();
            this.list.repaint();
        }
    }

    private void prepareForChange(RowSorterEvent sortEvent) {
        Contract.asNotNull(sortEvent, "sorter event not null");
        if (this.modelSelection == null && this.sorter.getViewRowCount() != this.sorter.getModelRowCount()) {
            int modelIndex;
            this.modelSelection = new DefaultListSelectionModel();
            ListSelectionModel viewSelection = this.getViewSelectionModel();
            int min = viewSelection.getMinSelectionIndex();
            int max = viewSelection.getMaxSelectionIndex();
            for (int viewIndex = min; viewIndex <= max; ++viewIndex) {
                if (!viewSelection.isSelectedIndex(viewIndex) || (modelIndex = this.convertRowIndexToModel(sortEvent, viewIndex)) == -1) continue;
                this.modelSelection.addSelectionInterval(modelIndex, modelIndex);
            }
            modelIndex = this.convertRowIndexToModel(sortEvent, viewSelection.getLeadSelectionIndex());
            SwingXUtilities.setLeadAnchorWithoutSelection(this.modelSelection, modelIndex, modelIndex);
        } else if (this.modelSelection == null) {
            this.cacheModelSelection(sortEvent);
        }
    }

    private void prepareForChange(ModelChange change) {
        Contract.asNotNull(change, "table event not null");
        if (change.allRowsChanged) {
            this.modelSelection = null;
        } else if (this.modelSelection != null) {
            switch (change.type) {
                case 2: {
                    this.modelSelection.removeIndexInterval(change.startModelIndex, change.endModelIndex);
                    break;
                }
                case 1: {
                    this.modelSelection.insertIndexInterval(change.startModelIndex, change.endModelIndex, true);
                    break;
                }
            }
        } else {
            this.cacheModelSelection(null);
        }
    }

    private void cacheModelSelection(RowSorterEvent sortEvent) {
        this.lastModelSelection = this.convertSelectionToModel(sortEvent);
        this.modelLeadIndex = this.convertRowIndexToModel(sortEvent, this.getViewSelectionModel().getLeadSelectionIndex());
    }

    private void processChange(ModelChange change) {
        if (change != null && change.allRowsChanged) {
            this.allChanged();
            this.getViewSelectionModel().clearSelection();
        } else if (this.sorterChanged) {
            this.restoreSelection(change);
        }
    }

    private void restoreSelection(ModelChange change) {
        this.syncingSelection = true;
        if (this.lastModelSelection != null) {
            this.restoreSortingSelection(this.lastModelSelection, this.modelLeadIndex, change);
            this.lastModelSelection = null;
        } else if (this.modelSelection != null) {
            ListSelectionModel viewSelection = this.getViewSelectionModel();
            viewSelection.setValueIsAdjusting(true);
            viewSelection.clearSelection();
            int min = this.modelSelection.getMinSelectionIndex();
            int max = this.modelSelection.getMaxSelectionIndex();
            for (int modelIndex = min; modelIndex <= max; ++modelIndex) {
                int viewIndex;
                if (!this.modelSelection.isSelectedIndex(modelIndex) || (viewIndex = this.sorter.convertRowIndexToView(modelIndex)) == -1) continue;
                viewSelection.addSelectionInterval(viewIndex, viewIndex);
            }
            int viewLeadIndex = this.modelSelection.getLeadSelectionIndex();
            if (viewLeadIndex != -1) {
                viewLeadIndex = this.sorter.convertRowIndexToView(viewLeadIndex);
            }
            SwingXUtilities.setLeadAnchorWithoutSelection(viewSelection, viewLeadIndex, viewLeadIndex);
            viewSelection.setValueIsAdjusting(false);
        }
        this.syncingSelection = false;
    }

    private void restoreSortingSelection(int[] selection, int lead, ModelChange change) {
        for (int i = selection.length - 1; i >= 0; --i) {
            selection[i] = this.convertRowIndexToView(change, selection[i]);
        }
        lead = this.convertRowIndexToView(change, lead);
        if (selection.length == 0 || selection.length == 1 && selection[0] == this.list.getSelectedIndex()) {
            return;
        }
        ListSelectionModel selectionModel = this.getViewSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int i = selection.length - 1; i >= 0; --i) {
            if (selection[i] == -1) continue;
            selectionModel.addSelectionInterval(selection[i], selection[i]);
        }
        SwingXUtilities.setLeadAnchorWithoutSelection(selectionModel, lead, lead);
        selectionModel.setValueIsAdjusting(false);
    }

    private int convertRowIndexToView(ModelChange change, int modelIndex) {
        if (modelIndex < 0) {
            return -1;
        }
        if (change != null && modelIndex >= change.startModelIndex) {
            if (change.type == 1) {
                if (modelIndex + change.length >= change.modelRowCount) {
                    return -1;
                }
                return this.sorter.convertRowIndexToView(modelIndex + change.length);
            }
            if (change.type == 2) {
                if (modelIndex <= change.endModelIndex) {
                    return -1;
                }
                if (modelIndex - change.length >= change.modelRowCount) {
                    return -1;
                }
                return this.sorter.convertRowIndexToView(modelIndex - change.length);
            }
        }
        if (modelIndex >= this.sorter.getModelRowCount()) {
            return -1;
        }
        return this.sorter.convertRowIndexToView(modelIndex);
    }

    private int convertRowIndexToModel(RowSorterEvent e, int viewIndex) {
        if (e != null) {
            if (e.getPreviousRowCount() == 0) {
                return viewIndex;
            }
            return e.convertPreviousRowIndexToModel(viewIndex);
        }
        if (viewIndex < 0 || viewIndex >= this.sorter.getViewRowCount()) {
            return -1;
        }
        return this.sorter.convertRowIndexToModel(viewIndex);
    }

    private int[] convertSelectionToModel(RowSorterEvent e) {
        int[] selection = this.list.getSelectedIndices();
        for (int i = selection.length - 1; i >= 0; --i) {
            selection[i] = this.convertRowIndexToModel(e, selection[i]);
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifySorter(ModelChange change) {
        try {
            this.ignoreSortChange = true;
            this.sorterChanged = false;
            if (change.allRowsChanged) {
                this.sorter.allRowsChanged();
                return;
            }
            switch (change.type) {
                case 0: {
                    this.sorter.rowsUpdated(change.startModelIndex, change.endModelIndex);
                    return;
                }
                case 1: {
                    this.sorter.rowsInserted(change.startModelIndex, change.endModelIndex);
                    return;
                }
                case 2: {
                    this.sorter.rowsDeleted(change.startModelIndex, change.endModelIndex);
                    return;
                }
            }
            return;
        }
        finally {
            this.ignoreSortChange = false;
        }
    }

    private ListSelectionModel getViewSelectionModel() {
        return this.list.getSelectionModel();
    }

    private void allChanged() {
        this.modelLeadIndex = -1;
        this.modelSelection = null;
    }

    protected RowSorterListener createRowSorterListener() {
        RowSorterListener l = new RowSorterListener(){

            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORTED) {
                    ListSortUI.this.sortedChanged(e);
                }
            }
        };
        return l;
    }

    static final class ModelChange {
        int startModelIndex;
        int endModelIndex;
        int length;
        int type;
        int modelRowCount;
        boolean allRowsChanged;

        public ModelChange(ListDataEvent e) {
            this.type = e.getType();
            this.modelRowCount = ((ListModel)e.getSource()).getSize();
            this.startModelIndex = e.getIndex0();
            this.endModelIndex = e.getIndex1();
            this.allRowsChanged = this.startModelIndex < 0;
            this.length = this.allRowsChanged ? -1 : this.endModelIndex - this.startModelIndex + 1;
        }
    }
}

