/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;

public class EmptyIcon
extends JBUI.CachingScalableJBIcon<EmptyIcon> {
    private static final Map<Pair<Integer, Boolean>, EmptyIcon> cache = new HashMap<Pair<Integer, Boolean>, EmptyIcon>();
    public static final Icon ICON_16 = JBUI.scale(EmptyIcon.create(16));
    public static final Icon ICON_18 = JBUI.scale(EmptyIcon.create(18));
    public static final Icon ICON_8 = JBUI.scale(EmptyIcon.create(8));
    public static final Icon ICON_0 = JBUI.scale(EmptyIcon.create(0));
    protected final int width;
    protected final int height;
    private final boolean myUseCache;

    public static EmptyIcon create(int size) {
        return EmptyIcon.create(size, size);
    }

    public static EmptyIcon create(int width, int height) {
        return EmptyIcon.create(width, height, true);
    }

    public static EmptyIcon create(@NotNull Icon base) {
        if (base == null) {
            EmptyIcon.$$$reportNull$$$0(0);
        }
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    private EmptyIcon(int width, int height, boolean useCache) {
        this.width = width;
        this.height = height;
        this.myUseCache = useCache;
    }

    protected EmptyIcon(EmptyIcon icon) {
        super(icon);
        this.width = icon.width;
        this.height = icon.height;
        this.myUseCache = icon.myUseCache;
    }

    @Override
    @NotNull
    protected EmptyIcon copy() {
        EmptyIcon emptyIcon = new EmptyIcon(this);
        if (emptyIcon == null) {
            EmptyIcon.$$$reportNull$$$0(1);
        }
        return emptyIcon;
    }

    @Override
    @NotNull
    public EmptyIcon withIconPreScaled(boolean preScaled) {
        if (this.myUseCache && this.isIconPreScaled() != preScaled) {
            EmptyIcon emptyIcon = EmptyIcon.create(this.width, this.height, preScaled);
            if (emptyIcon == null) {
                EmptyIcon.$$$reportNull$$$0(2);
            }
            return emptyIcon;
        }
        EmptyIcon emptyIcon = (EmptyIcon)super.withIconPreScaled(preScaled);
        if (emptyIcon == null) {
            EmptyIcon.$$$reportNull$$$0(3);
        }
        return emptyIcon;
    }

    private static EmptyIcon create(int width, int height, boolean preScaled) {
        EmptyIcon icon;
        Pair<Integer, Boolean> key = EmptyIcon.key(width, height, preScaled);
        EmptyIcon emptyIcon = icon = key != null ? cache.get(key) : null;
        if (icon == null) {
            icon = new EmptyIcon(width, height, true);
            icon.setIconPreScaled(preScaled);
            if (key != null) {
                cache.put(key, icon);
            }
        }
        return icon;
    }

    @Nullable
    private static Pair<Integer, Boolean> key(int width, int height, boolean preScaled) {
        return width == height && width < 129 ? Pair.create(width, preScaled) : null;
    }

    @Override
    public int getIconWidth() {
        return (int)Math.ceil(this.scaleVal(this.width));
    }

    @Override
    public int getIconHeight() {
        return (int)Math.ceil(this.scaleVal(this.height));
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        if (this.scaleVal(this.height, JBUI.ScaleType.PIX_SCALE) != icon.scaleVal(icon.height, JBUI.ScaleType.PIX_SCALE)) {
            return false;
        }
        return this.scaleVal(this.width, JBUI.ScaleType.PIX_SCALE) == icon.scaleVal(icon.width, JBUI.ScaleType.PIX_SCALE);
    }

    public int hashCode() {
        double result2 = this.scaleVal(this.width, JBUI.ScaleType.PIX_SCALE);
        result2 = 31.0 * result2 + this.scaleVal(this.height, JBUI.ScaleType.PIX_SCALE);
        return (int)result2;
    }

    static {
        JBUI.addPropertyChangeListener("JBUI.userScaleFactor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                cache.clear();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/EmptyIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EmptyIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withIconPreScaled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

