/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ProgressStartEventSerializer
implements Serializer<ProgressStartEvent> {
    private static final short PARENT_PROGRESS_ID = 1;
    private static final short LOGGING_HEADER = 4;
    private static final short LOGGING_HEADER_IS_SUB_DESCRIPTION = 8;
    private static final short STATUS = 16;
    private static final short STATUS_IS_SUB_DESCRIPTION = 32;
    private static final short BUILD_OPERATION_ID = 64;
    private static final short BUILD_OPERATION_ID_IS_PROGRESS_ID = 128;
    private static final short BUILD_OPERATION_START = 256;
    private static final short CATEGORY_IS_TASK = 512;
    private static final short CATEGORY_IS_BUILD_OP = 1024;
    private static final short CATEGORY_NAME = 2048;
    private static final short BUILD_OP_CATEGORY_OFFSET = 12;
    private static final short BUILD_OP_CATEGORY_MASK = 7;

    public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
        OperationIdentifier buildOperationId;
        String status;
        int flags = 0;
        OperationIdentifier parentProgressOperationId = event.getParentProgressOperationId();
        if (parentProgressOperationId != null) {
            flags |= 1;
        }
        String description = event.getDescription();
        String loggingHeader = event.getLoggingHeader();
        if (loggingHeader != null) {
            flags = description.endsWith(loggingHeader) ? (flags |= 8) : (flags |= 4);
        }
        if (!(status = event.getStatus()).isEmpty()) {
            flags = description.endsWith(status) ? (flags |= 0x20) : (flags |= 0x10);
        }
        if ((buildOperationId = event.getBuildOperationId()) != null) {
            flags = buildOperationId.equals((Object)event.getProgressOperationId()) ? (flags |= 0x80) : (flags |= 0x40);
        }
        BuildOperationCategory buildOperationCategory = event.getBuildOperationCategory();
        flags |= (buildOperationCategory.ordinal() & 7) << 12;
        if (event.isBuildOperationStart()) {
            flags |= 0x100;
        }
        flags = event.getCategory().equals("org.gradle.internal.logging.progress.ProgressLoggerFactory") ? (flags |= 0x400) : (event.getCategory().equals("class org.gradle.internal.buildevents.TaskExecutionLogger") ? (flags |= 0x200) : (flags |= 0x800));
        encoder.writeSmallInt(flags);
        encoder.writeSmallLong(event.getProgressOperationId().getId());
        if (parentProgressOperationId != null) {
            encoder.writeSmallLong(parentProgressOperationId.getId());
        }
        encoder.writeLong(event.getTimestamp());
        if ((flags & 0x800) != 0) {
            encoder.writeString((CharSequence)event.getCategory());
        }
        encoder.writeString((CharSequence)description);
        if ((flags & 4) != 0) {
            encoder.writeString((CharSequence)loggingHeader);
        } else if ((flags & 8) != 0) {
            encoder.writeSmallInt(loggingHeader.length());
        }
        if ((flags & 0x10) != 0) {
            encoder.writeString((CharSequence)status);
        } else if ((flags & 0x20) != 0) {
            encoder.writeSmallInt(status.length());
        }
        encoder.writeSmallInt(event.getTotalProgress());
        if ((flags & 0x40) != 0) {
            encoder.writeSmallLong(buildOperationId.getId());
        }
    }

    public ProgressStartEvent read(Decoder decoder) throws Exception {
        long flags = decoder.readSmallInt();
        OperationIdentifier progressOperationId = new OperationIdentifier(decoder.readSmallLong());
        OperationIdentifier parentProgressOperationId = null;
        if ((flags & 1L) != 0L) {
            parentProgressOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        long timestamp = decoder.readLong();
        String category = (flags & 0x200L) != 0L ? "class org.gradle.internal.buildevents.TaskExecutionLogger" : ((flags & 0x400L) != 0L ? "org.gradle.internal.logging.progress.ProgressLoggerFactory" : decoder.readString());
        String description = decoder.readString();
        String loggingHeader = null;
        if ((flags & 4L) != 0L) {
            loggingHeader = decoder.readString();
        } else if ((flags & 8L) != 0L) {
            int length = decoder.readSmallInt();
            loggingHeader = description.substring(description.length() - length);
        }
        String status = "";
        if ((flags & 0x10L) != 0L) {
            status = decoder.readString();
        } else if ((flags & 0x20L) != 0L) {
            int length = decoder.readSmallInt();
            status = description.substring(description.length() - length);
        }
        int totalProgress = decoder.readSmallInt();
        boolean buildOperationStart = (flags & 0x100L) != 0L;
        OperationIdentifier buildOperationId = null;
        if ((flags & 0x40L) != 0L) {
            buildOperationId = new OperationIdentifier(decoder.readSmallLong());
        } else if ((flags & 0x80L) != 0L) {
            buildOperationId = progressOperationId;
        }
        BuildOperationCategory buildOperationCategory = BuildOperationCategory.values()[(int)(flags >> 12 & 7L)];
        return new ProgressStartEvent(progressOperationId, parentProgressOperationId, timestamp, category, description, loggingHeader, status, totalProgress, buildOperationStart, buildOperationId, buildOperationCategory);
    }
}

