/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenChangesetPopupMenu
extends JPopupMenu {
    private static final List<ChangesetViewerEntry> DEFAULT_ENTRIES = Arrays.asList(new ChangesetViewerEntry(I18n.tr("View changeset in web browser", new Object[0]), Config.getUrls().getBaseBrowseUrl() + "/changeset/{0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "achavi (Augmented OSM Change Viewer)"), "https://overpass-api.de/achavi/?changeset={0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "OSMCha (OSM Changeset Analyzer)"), "https://osmcha.mapbox.com/changesets/{0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "OSM History Viewer"), "http://osmhv.openstreetmap.de/changeset.jsp?id={0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "WhoDidIt (OSM Changeset Analyzer)"), "http://simon04.dev.openstreetmap.org/whodidit/index.html?changeset={0}&show=1"));

    public OpenChangesetPopupMenu(long changesetId) {
        StructUtils.getListOfStructs(Config.getPref(), "history-dialog.tools", DEFAULT_ENTRIES, ChangesetViewerEntry.class).stream().map(entry -> entry.toAction(changesetId)).forEach(this::add);
    }

    public void show(JComponent parent) {
        Rectangle r = parent.getBounds();
        this.show(parent.getParent(), r.x, r.y + r.height);
    }

    static class OpenBrowserAction
    extends AbstractAction {
        final String url;

        OpenBrowserAction(String name, String url) {
            super(name);
            this.putValue("ShortDescription", I18n.tr("Open {0}", url));
            new ImageProvider("help/internet").getResource().attachImageIcon(this, true);
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(this.url);
        }
    }

    public static class ChangesetViewerEntry {
        @StructUtils.StructEntry
        public String name;
        @StructUtils.StructEntry
        public String url;

        public ChangesetViewerEntry() {
        }

        ChangesetViewerEntry(String name, String url) {
            this.name = name;
            this.url = url;
        }

        Action toAction(long changesetId) {
            return new OpenBrowserAction(this.name, MessageFormat.format(this.url, Long.toString(changesetId)));
        }
    }
}

