/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;

public class CredentialDialog
extends JDialog {
    private boolean canceled;
    protected CredentialPanel pnlCredentials;
    private final String saveUsernameAndPasswordCheckboxText;

    public static CredentialDialog getOsmApiCredentialDialog(String username, String password, String host, String saveUsernameAndPasswordCheckboxText) {
        CredentialDialog dialog = new CredentialDialog(saveUsernameAndPasswordCheckboxText);
        if (Objects.equals(OsmApi.getOsmApi().getHost(), host)) {
            dialog.prepareForOsmApiCredentials(username, password);
        } else {
            dialog.prepareForOtherHostCredentials(username, password, host);
        }
        dialog.pack();
        return dialog;
    }

    public static CredentialDialog getHttpProxyCredentialDialog(String username, String password, String host, String saveUsernameAndPasswordCheckboxText) {
        CredentialDialog dialog = new CredentialDialog(saveUsernameAndPasswordCheckboxText);
        dialog.prepareForProxyCredentials(username, password);
        dialog.pack();
        return dialog;
    }

    public static void promptCredentials(Authenticator.RequestorType requestorType, AbstractCredentialsAgent agent, CredentialsAgentResponse response, String username, String password, String host) {
        GuiHelper.runInEDTAndWait(() -> {
            CredentialDialog dialog = requestorType.equals((Object)Authenticator.RequestorType.PROXY) ? CredentialDialog.getHttpProxyCredentialDialog(username, password, host, agent.getSaveUsernameAndPasswordCheckboxText()) : CredentialDialog.getOsmApiCredentialDialog(username, password, host, agent.getSaveUsernameAndPasswordCheckboxText());
            dialog.setVisible(true);
            response.setCanceled(dialog.isCanceled());
            if (dialog.isCanceled()) {
                return;
            }
            response.setUsername(dialog.getUsername());
            response.setPassword(dialog.getPassword());
            response.setSaveCredentials(dialog.isSaveCredentials());
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(350, 300)).applySafe(this);
        }
        super.setVisible(visible);
    }

    protected JPanel createButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout());
        pnl.add(new JButton(new OKAction()));
        pnl.add(new JButton(new CancelAction()));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/Password"))));
        return pnl;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowEventHander());
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public CredentialDialog(String saveUsernameAndPasswordCheckboxText) {
        this.saveUsernameAndPasswordCheckboxText = saveUsernameAndPasswordCheckboxText;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to put Credential Dialog always on top. Caught security exception.", new Object[0]), e);
        }
        this.build();
    }

    public void prepareForOsmApiCredentials(String username, String password) {
        this.setTitle(I18n.tr("Enter credentials for OSM API", new Object[0]));
        this.pnlCredentials = new OsmApiCredentialsPanel(this);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    public void prepareForOtherHostCredentials(String username, String password, String host) {
        this.setTitle(I18n.tr("Enter credentials for host", new Object[0]));
        this.pnlCredentials = new OtherHostCredentialsPanel(this, host);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    public void prepareForProxyCredentials(String username, String password) {
        this.setTitle(I18n.tr("Enter credentials for HTTP proxy", new Object[0]));
        this.pnlCredentials = new HttpProxyCredentialsPanel(this);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    public String getUsername() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getUserName();
    }

    public char[] getPassword() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getPassword();
    }

    public boolean isSaveCredentials() {
        if (this.pnlCredentials == null) {
            return false;
        }
        return this.pnlCredentials.isSaveCredentials();
    }

    class WindowEventHander
    extends WindowAdapter {
        WindowEventHander() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (CredentialDialog.this.pnlCredentials != null) {
                CredentialDialog.this.pnlCredentials.startUserInput();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().cancel();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Cancel authentication", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
        }

        public void cancel() {
            CredentialDialog.this.setCanceled(true);
            CredentialDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", I18n.tr("Authenticate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Authenticate with the supplied username and password", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CredentialDialog.this.setCanceled(false);
            CredentialDialog.this.setVisible(false);
        }
    }

    private static class TFKeyListener
    extends KeyAdapter {
        protected CredentialDialog owner;
        protected JTextField currentTF;
        protected JTextField nextTF;

        TFKeyListener(CredentialDialog owner, JTextField currentTF, JTextField nextTF) {
            this.owner = owner;
            this.currentTF = currentTF;
            this.nextTF = nextTF;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                if (this.currentTF.getText().trim().isEmpty()) {
                    this.currentTF.selectAll();
                } else if (this.nextTF.getText().trim().isEmpty()) {
                    this.nextTF.requestFocusInWindow();
                    this.nextTF.selectAll();
                } else {
                    this.owner.new OKAction().actionPerformed(null);
                }
            }
        }
    }

    private static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private SelectAllOnFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                ((JTextField)e.getSource()).selectAll();
            }
        }
    }

    private static class HttpProxyCredentialsPanel
    extends CredentialPanel {
        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name for authenticating at your proxy server", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password for authenticating at your proxy server", new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the HTTP proxy ''{0}'' failed. Please enter a valid username and a valid password.", Config.getPref().get("proxy.http.host") + ':' + Config.getPref().get("proxy.http.port")) + "</html>");
            this.lblWarning.setText("<html>" + I18n.tr("Warning: depending on the authentication method the proxy server uses the password may be transferred unencrypted.", new Object[0]) + "</html>");
        }

        HttpProxyCredentialsPanel(CredentialDialog owner) {
            super(owner);
            this.build();
        }
    }

    private static class OtherHostCredentialsPanel
    extends CredentialPanel {
        private final String host;

        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your account", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your account", new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the host ''{0}'' failed. Please enter a valid username and a valid password.", this.host) + "</html>");
            this.updateWarningLabel(this.host);
        }

        OtherHostCredentialsPanel(CredentialDialog owner, String host) {
            super(owner);
            this.host = host;
            this.build();
        }
    }

    private static class OsmApiCredentialsPanel
    extends CredentialPanel {
        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your OSM account", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your OSM account", new Object[0]));
            String apiUrl = OsmApi.getOsmApi().getBaseUrl();
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the OSM API ''{0}'' failed. Please enter a valid username and a valid password.", apiUrl) + "</html>");
            this.updateWarningLabel(apiUrl);
        }

        OsmApiCredentialsPanel(CredentialDialog owner) {
            super(owner);
            this.build();
        }
    }

    protected static class CredentialPanel
    extends JPanel {
        protected JosmTextField tfUserName;
        protected JosmPasswordField tfPassword;
        protected JCheckBox cbSaveCredentials;
        protected final JMultilineLabel lblHeading = new JMultilineLabel("");
        protected final JMultilineLabel lblWarning = new JMultilineLabel("");
        protected CredentialDialog owner;

        protected void build() {
            this.tfUserName = new JosmTextField(20);
            this.tfPassword = new JosmPasswordField(20);
            this.tfUserName.addFocusListener(new SelectAllOnFocusHandler());
            this.tfPassword.addFocusListener(new SelectAllOnFocusHandler());
            this.tfUserName.addKeyListener(new TFKeyListener(this.owner, this.tfUserName, this.tfPassword));
            this.tfPassword.addKeyListener(new TFKeyListener(this.owner, this.tfPassword, this.tfUserName));
            this.cbSaveCredentials = new JCheckBox(this.owner != null ? this.owner.saveUsernameAndPasswordCheckboxText : "");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridwidth = 2;
            gc.gridheight = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(0, 0, 10, 0);
            this.add((Component)this.lblHeading, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.gridheight = 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(0, 0, 10, 10);
            this.add((Component)new JLabel(I18n.tr("Username", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfUserName, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Password", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.weightx = 0.0;
            this.add((Component)this.tfPassword, gc);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.gridwidth = 2;
            gc.gridheight = 1;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            this.lblWarning.setFont(this.lblWarning.getFont().deriveFont(2));
            this.add((Component)this.lblWarning, gc);
            gc.gridx = 0;
            gc.gridy = 4;
            gc.weighty = 0.0;
            this.add((Component)this.cbSaveCredentials, gc);
            gc.gridx = 0;
            gc.gridy = 5;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public CredentialPanel(CredentialDialog owner) {
            this.owner = owner;
        }

        public void init(String username, String password) {
            username = username == null ? "" : username;
            password = password == null ? "" : password;
            this.tfUserName.setText(username);
            this.tfPassword.setText(password);
            this.cbSaveCredentials.setSelected(!username.isEmpty() && !password.isEmpty());
        }

        public void startUserInput() {
            this.tfUserName.requestFocusInWindow();
        }

        public String getUserName() {
            return this.tfUserName.getText();
        }

        public char[] getPassword() {
            return this.tfPassword.getPassword();
        }

        public boolean isSaveCredentials() {
            return this.cbSaveCredentials.isSelected();
        }

        protected final void updateWarningLabel(String url) {
            boolean https;
            boolean bl = https = url != null && url.startsWith("https");
            if (https) {
                this.lblWarning.setText(null);
            } else {
                this.lblWarning.setText(I18n.tr("Warning: The password is transferred unencrypted.", new Object[0]));
            }
            this.lblWarning.setVisible(!https);
        }
    }
}

