/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.languagetool.Experimental;

@Experimental
public class UserConfig {
    private final List<String> userSpecificSpellerWords;
    private final int maxSpellingSuggestions;
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();

    public UserConfig() {
        this(new ArrayList<String>(), new HashMap<String, Integer>());
    }

    public UserConfig(List<String> userSpecificSpellerWords) {
        this(userSpecificSpellerWords, new HashMap<String, Integer>());
    }

    public UserConfig(Map<String, Integer> ruleValues) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues));
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues) {
        this(userSpecificSpellerWords, ruleValues, 0);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions) {
        this.userSpecificSpellerWords = Objects.requireNonNull(userSpecificSpellerWords);
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
        this.maxSpellingSuggestions = maxSpellingSuggestions;
    }

    public List<String> getAcceptedWords() {
        return this.userSpecificSpellerWords;
    }

    public int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    public Map<String, Integer> getConfigValues() {
        return this.configurableRuleValues;
    }

    public void insertConfigValues(Map<String, Integer> ruleValues) {
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
    }

    public int getConfigValueByID(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConfig that = (UserConfig)o;
        if (this.maxSpellingSuggestions != that.maxSpellingSuggestions) {
            return false;
        }
        if (!this.userSpecificSpellerWords.equals(that.userSpecificSpellerWords)) {
            return false;
        }
        return this.configurableRuleValues.equals(that.configurableRuleValues);
    }

    public int hashCode() {
        int result = this.userSpecificSpellerWords.hashCode();
        result = 31 * result + this.maxSpellingSuggestions;
        result = 31 * result + this.configurableRuleValues.hashCode();
        return result;
    }
}

