"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const serviceManager_1 = require("../serviceManager");
const file_1 = require("../utils/file");
const semver = require("semver");
const debug_1 = require("debug");
const debug = debug_1.default('axm:coveragefeature');
class CoverageFeature {
    constructor() {
        this.inspectorService = serviceManager_1.ServiceManager.get('inspector');
    }
    init() {
        if (semver.satisfies(process.version, '< 8.0.0') ||
            (semver.satisfies(process.version, '< 10.0.0') && !process.env.FORCE_INSPECTOR)) {
            return new Promise(resolve => {
                debug(`Coverage feature is not available for node < 8.0.0 (force inspector : ${process.env.FORCE_INSPECTOR}), current version ${process.version}`);
                resolve(`Coverage feature is not available for node < 8.0.0 (force inspector : ${process.env.FORCE_INSPECTOR}), current version ${process.version}`);
            });
        }
        this.inspectorService.createSession();
        this.inspectorService.connect();
        return this.inspectorService.post('Profiler.enable');
    }
    destroy() {
        this.inspectorService.disconnect();
    }
    start(opts) {
        this.method = !opts.method ? 'takePreciseCoverage' : opts.method;
        return this.inspectorService.post('Profiler.startPreciseCoverage', { callCount: !!opts.callCount, detailed: !!opts.detailed });
    }
    stop() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const data = yield this.getInfo();
            return file_1.default.writeDumpFile(JSON.stringify(data), '.coverageprofile');
        });
    }
    getInfo() {
        // const self = this
        return new Promise((resolve, reject) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const data = yield this.inspectorService.post('Profiler.' + this.method);
                yield this.inspectorService.post('Profiler.stopPreciseCoverage');
                return resolve(data);
            }
            catch (err) {
                debug('Coverage profiling stopped !', err);
                return reject(err);
            }
        }));
    }
}
exports.default = CoverageFeature;
//# sourceMappingURL=data:application/json;base64,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