/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.editorkit;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.core.editorkit.EditorKitFactory;

public final class EditorKitDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_KEY = "EDITOR_KIT_LABEL";
    private static final String EDITOR_KIT_FACTORY_ID = "EDITOR_KIT_FACTORY_ID";
    private final Properties properties = new Properties();

    public EditorKitDescriptor(@Nonnull String label, @Nonnull EditorKitFactory editorKitFactory) {
        this.setEditorKitFactoryID((String)Preconditions.checkNotNull((Object)editorKitFactory.getId()));
        this.properties.setProperty(LABEL_KEY, (String)Preconditions.checkNotNull((Object)label));
    }

    @Nonnull
    public String getLabel() {
        return this.properties.getProperty(LABEL_KEY);
    }

    @Nonnull
    public String getEditorKitFactoryID() {
        return this.properties.getProperty(EDITOR_KIT_FACTORY_ID);
    }

    public void setEditorKitFactoryID(@Nonnull String id) {
        this.properties.setProperty(EDITOR_KIT_FACTORY_ID, (String)Preconditions.checkNotNull((Object)id));
    }

    @Nullable
    public String getString(@Nonnull String key) {
        return (String)this.properties.get(Preconditions.checkNotNull((Object)key));
    }

    public void setString(@Nonnull String key, @Nonnull String value) {
        this.properties.put(key, value);
    }

    public void setURI(@Nonnull String key, @Nonnull URI uri) {
        this.properties.put(Preconditions.checkNotNull((Object)key), Preconditions.checkNotNull((Object)uri));
    }

    @Nullable
    public URI getURI(@Nonnull String key) {
        return (URI)this.properties.get(key);
    }

    public boolean equals(Object obj) {
        return obj instanceof EditorKitDescriptor && this.getLabel().equals(((EditorKitDescriptor)obj).getLabel());
    }

    @Nonnull
    public String toString() {
        return this.getLabel();
    }
}

