/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class RepositoryResolver
extends AbstractPatternsBasedResolver {
    private Repository repository;
    private Boolean alwaysCheckExactRevision = null;
    private String signerName = null;

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.repository instanceof AbstractRepository) {
            ((AbstractRepository)this.repository).setName(string);
        }
    }

    public void setSigner(String string) {
        this.signerName = string;
    }

    @Override
    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId moduleRevisionId, String string, Artifact artifact, ResourceMDParser resourceMDParser, Date date) {
        String string2 = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        try {
            if (!versionMatcher.isDynamic(moduleRevisionId) || this.isAlwaysCheckExactRevision()) {
                String string3 = IvyPatternHelper.substitute(string, moduleRevisionId, artifact);
                Message.debug("\t trying " + string3);
                this.logAttempt(string3);
                Resource resource = this.repository.getResource(string3);
                boolean bl = resource.exists();
                if (bl) {
                    String string4;
                    if (string.indexOf("revision") == -1) {
                        if ("ivy".equals(artifact.getType()) || "pom".equals(artifact.getType())) {
                            File file = File.createTempFile("ivy", artifact.getExt());
                            file.deleteOnExit();
                            this.repository.get(resource.getName(), file);
                            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resource);
                            ModuleDescriptor moduleDescriptor = moduleDescriptorParser.parseDescriptor(this.getParserSettings(), file.toURI().toURL(), resource, false);
                            string4 = moduleDescriptor.getRevision();
                            if (string4 == null || string4.length() == 0) {
                                string4 = "working@" + string2;
                            }
                        } else {
                            string4 = "working@" + string2;
                        }
                    } else {
                        string4 = moduleRevisionId.getRevision();
                    }
                    return new ResolvedResource(resource, string4);
                }
                if (versionMatcher.isDynamic(moduleRevisionId)) {
                    return this.findDynamicResourceUsingPattern(resourceMDParser, moduleRevisionId, string, artifact, date);
                }
                Message.debug("\t" + string2 + ": resource not reachable for " + moduleRevisionId + ": res=" + resource);
                return null;
            }
            return this.findDynamicResourceUsingPattern(resourceMDParser, moduleRevisionId, string, artifact, date);
        }
        catch (IOException iOException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + iOException, iOException);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + parseException, parseException);
        }
    }

    private ResolvedResource findDynamicResourceUsingPattern(ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, String string, Artifact artifact, Date date) {
        String string2 = this.getName();
        this.logAttempt(IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), artifact));
        ResolvedResource[] resolvedResourceArray = this.listResources(this.repository, moduleRevisionId, string, artifact);
        if (resolvedResourceArray == null) {
            Message.debug("\t" + string2 + ": unable to list resources for " + moduleRevisionId + ": pattern=" + string);
            return null;
        }
        ResolvedResource resolvedResource = this.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        if (resolvedResource == null) {
            Message.debug("\t" + string2 + ": no resource found for " + moduleRevisionId + ": pattern=" + string);
        }
        return resolvedResource;
    }

    @Override
    protected Resource getResource(String string) throws IOException {
        return this.repository.getResource(string);
    }

    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        return ResolverHelper.findAll(repository, moduleRevisionId, string, artifact);
    }

    @Override
    protected long get(Resource resource, File file) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + file);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.repository.get(resource.getName(), file);
        return file.length();
    }

    @Override
    public void publish(Artifact artifact, File file, boolean bl) throws IOException {
        String string;
        if ("ivy".equals(artifact.getType()) && !this.getIvyPatterns().isEmpty()) {
            string = (String)this.getIvyPatterns().get(0);
        } else if (!this.getArtifactPatterns().isEmpty()) {
            string = (String)this.getArtifactPatterns().get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        String string2 = this.getDestination(string, artifact, moduleRevisionId);
        this.put(artifact, file, string2, bl);
        Message.info("\tpublished " + artifact.getName() + " to " + this.hidePassword(this.repository.standardize(string2)));
    }

    protected String getDestination(String string, Artifact artifact, ModuleRevisionId moduleRevisionId) {
        return IvyPatternHelper.substitute(string, moduleRevisionId, artifact);
    }

    protected void put(Artifact artifact, File file, String string, boolean bl) throws IOException {
        int n;
        String[] stringArray = this.getChecksumAlgorithms();
        for (n = 0; n < stringArray.length; ++n) {
            if (ChecksumHelper.isKnownAlgorithm(stringArray[n])) continue;
            throw new IllegalArgumentException("Unknown checksum algorithm: " + stringArray[n]);
        }
        this.repository.put(artifact, file, string, bl);
        for (n = 0; n < stringArray.length; ++n) {
            this.putChecksum(artifact, file, string, bl, stringArray[n]);
        }
        if (this.signerName != null) {
            this.putSignature(artifact, file, string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putChecksum(Artifact artifact, File file, String string, boolean bl, String string2) throws IOException {
        File file2 = File.createTempFile("ivytemp", string2);
        try {
            FileUtil.copy((InputStream)new ByteArrayInputStream(ChecksumHelper.computeAsString(file, string2).getBytes()), file2, null);
            this.repository.put(DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, string2, artifact.getExt() + "." + string2), file2, string + "." + string2, bl);
        }
        finally {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSignature(Artifact artifact, File file, String string, boolean bl) throws IOException {
        SignatureGenerator signatureGenerator = this.getSettings().getSignatureGenerator(this.signerName);
        if (signatureGenerator == null) {
            throw new IllegalArgumentException("Couldn't sign the artifacts! Unknown signer name: '" + this.signerName + "'");
        }
        File file2 = File.createTempFile("ivytemp", signatureGenerator.getExtension());
        try {
            signatureGenerator.sign(file, file2);
            this.repository.put(DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, signatureGenerator.getExtension(), artifact.getExt() + "." + signatureGenerator.getExtension()), file2, string + "." + signatureGenerator.getExtension(), bl);
        }
        finally {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        EventManager eventManager = this.getEventManager();
        try {
            if (eventManager != null) {
                this.repository.addTransferListener(eventManager);
            }
            DownloadReport downloadReport = super.download(artifactArray, downloadOptions);
            return downloadReport;
        }
        finally {
            if (eventManager != null) {
                this.repository.removeTransferListener(eventManager);
            }
        }
    }

    @Override
    protected void findTokenValues(Collection collection, List list, Map map, String string) {
        for (String string2 : list) {
            String string3 = IvyPatternHelper.substituteTokens(string2, map);
            String[] stringArray = ResolverHelper.listTokenValues(this.repository, string3, string);
            if (stringArray == null) continue;
            collection.addAll(this.filterNames(new ArrayList<String>(Arrays.asList(stringArray))));
        }
    }

    @Override
    protected String[] listTokenValues(String string, String string2) {
        return ResolverHelper.listTokenValues(this.repository, string, string2);
    }

    @Override
    protected boolean exist(String string) {
        try {
            Resource resource = this.repository.getResource(string);
            return resource.exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String getTypeName() {
        return "repository";
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    @Override
    public void setSettings(ResolverSettings resolverSettings) {
        super.setSettings(resolverSettings);
        if (resolverSettings != null && this.alwaysCheckExactRevision == null) {
            this.alwaysCheckExactRevision = Boolean.valueOf(resolverSettings.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        return this.alwaysCheckExactRevision == null ? true : this.alwaysCheckExactRevision;
    }

    public void setAlwaysCheckExactRevision(boolean bl) {
        this.alwaysCheckExactRevision = bl;
    }
}

