/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptAPI
extends ApiImplementor {
    private static final String PREFIX = "script";
    private static final String VIEW_ENGINES = "listEngines";
    private static final String VIEW_SCRIPTS = "listScripts";
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final String ACTION_RUN_STANDALONE = "runStandAloneScript";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_REMOVE = "remove";
    private static final String ACTION_PARAM_SCRIPT_NAME = "scriptName";
    private static final String ACTION_PARAM_SCRIPT_DESC = "scriptDescription";
    private static final String ACTION_PARAM_SCRIPT_TYPE = "scriptType";
    private static final String ACTION_PARAM_SCRIPT_ENGINE = "scriptEngine";
    private static final String ACTION_PARAM_FILE_NAME = "fileName";
    private static final String ACTION_PARAM_CHARSET = "charset";
    private ExtensionScript extension;

    public ScriptAPI(ExtensionScript extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_ENGINES, new String[0], new String[0]));
        this.addApiView(new ApiView(VIEW_SCRIPTS, new String[0], new String[0]));
        this.addApiAction(new ApiAction(ACTION_ENABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_DISABLE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_LOAD, new String[]{ACTION_PARAM_SCRIPT_NAME, ACTION_PARAM_SCRIPT_TYPE, ACTION_PARAM_SCRIPT_ENGINE, ACTION_PARAM_FILE_NAME}, new String[]{ACTION_PARAM_SCRIPT_DESC, ACTION_PARAM_CHARSET}));
        this.addApiAction(new ApiAction(ACTION_REMOVE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
        this.addApiAction(new ApiAction(ACTION_RUN_STANDALONE, new String[]{ACTION_PARAM_SCRIPT_NAME}, new String[0]));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if (VIEW_SCRIPTS.equals(name)) {
            ApiResponseList result = new ApiResponseList(name);
            for (ScriptType type : this.extension.getScriptTypes()) {
                for (ScriptWrapper script : this.extension.getScripts(type)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", script.getName());
                    map.put("type", script.getTypeName());
                    map.put("engine", script.getEngineName());
                    map.put("description", script.getDescription());
                    map.put("error", Boolean.toString(script.isError()));
                    if (script.isError()) {
                        map.put("lastError", script.getLastErrorDetails());
                    }
                    if (type.isEnableable()) {
                        map.put("enabled", Boolean.toString(script.isEnabled()));
                    }
                    result.addItem(new ApiResponseSet("Script", map));
                }
            }
            return result;
        }
        if (VIEW_ENGINES.equals(name)) {
            ApiResponseList result = new ApiResponseList(name);
            for (String engine : this.extension.getScriptingEngines()) {
                result.addItem(new ApiResponseElement("engine", engine));
            }
            return result;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (ACTION_ENABLE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.setEnabled(script, true);
            return ApiResponseElement.OK;
        }
        if (ACTION_DISABLE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().isEnableable()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.setEnabled(script, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD.equals(name)) {
            ScriptEngineWrapper engine;
            ScriptType type = this.extension.getScriptType(params.getString(ACTION_PARAM_SCRIPT_TYPE));
            if (type == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_TYPE);
            }
            try {
                engine = this.extension.getEngineWrapper(params.getString(ACTION_PARAM_SCRIPT_ENGINE));
            }
            catch (InvalidParameterException e) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_ENGINE, e);
            }
            File file = new File(params.getString(ACTION_PARAM_FILE_NAME));
            if (!file.exists()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, file.getAbsolutePath());
            }
            ScriptWrapper script = new ScriptWrapper(params.getString(ACTION_PARAM_SCRIPT_NAME), this.getParam(params, ACTION_PARAM_SCRIPT_DESC, ""), engine, type, true, file);
            Charset charset = ScriptAPI.getCharset(params);
            try {
                if (charset != null) {
                    this.extension.loadScript(script, charset);
                } else {
                    this.extension.loadScript(script);
                }
            }
            catch (MalformedInputException e) {
                throw new ApiException(charset != null ? ApiException.Type.ILLEGAL_PARAMETER : ApiException.Type.MISSING_PARAMETER, ACTION_PARAM_CHARSET, e);
            }
            catch (IOException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            this.extension.addScript(script, false);
            return ApiResponseElement.OK;
        }
        if (ACTION_REMOVE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            this.extension.removeScript(script);
            return ApiResponseElement.OK;
        }
        if (ACTION_RUN_STANDALONE.equals(name)) {
            ScriptWrapper script = this.extension.getScript(params.getString(ACTION_PARAM_SCRIPT_NAME));
            if (script == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, ACTION_PARAM_SCRIPT_NAME);
            }
            if (!script.getType().getName().equals("standalone")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Parameter scriptName does not match a standalone script.");
            }
            try {
                this.extension.invokeScript(script);
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            return ApiResponseElement.OK;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private static Charset getCharset(JSONObject params) throws ApiException {
        if (!params.has(ACTION_PARAM_CHARSET)) {
            return null;
        }
        String charsetName = params.getString(ACTION_PARAM_CHARSET);
        if (charsetName.isEmpty()) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, ACTION_PARAM_CHARSET, e);
        }
    }
}

