/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.NullMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassProvider;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Java::JavaPackage"}, parent="Module")
public class JavaPackage
extends RubyModule {
    final String packageName;

    static RubyModule createJavaPackageClass(Ruby runtime2, RubyModule Java2) {
        BlankSlateWrapper superClass = new BlankSlateWrapper(runtime2, runtime2.getModule(), runtime2.getKernel());
        RubyClass JavaPackage2 = RubyClass.newClass(runtime2, superClass);
        JavaPackage2.setMetaClass(runtime2.getModule());
        JavaPackage2.setAllocator(ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ((MetaClass)JavaPackage2.makeMetaClass(superClass)).setAttached(JavaPackage2);
        JavaPackage2.setBaseName("JavaPackage");
        JavaPackage2.setParent(Java2);
        Java2.setConstant("JavaPackage", JavaPackage2);
        runtime2.getObject().setConstant("JavaPackageModuleTemplate", JavaPackage2);
        runtime2.getObject().deprecateConstant(runtime2, "JavaPackageModuleTemplate");
        JavaPackage2.defineAnnotatedMethods(JavaPackage.class);
        return JavaPackage2;
    }

    static RubyModule newPackage(Ruby runtime2, CharSequence name2, RubyModule parent) {
        JavaPackage pkgModule = new JavaPackage(runtime2, name2);
        pkgModule.addClassProvider(JavaClassProvider.INSTANCE);
        return pkgModule;
    }

    static CharSequence buildPackageName(RubyModule parentPackage, String name2) {
        return ((JavaPackage)parentPackage).packageRelativeName(name2);
    }

    private JavaPackage(Ruby runtime2, CharSequence packageName) {
        super(runtime2, runtime2.getJavaSupport().getJavaPackageClass());
        this.packageName = packageName.toString();
    }

    @JRubyMethod(name={"package_name"}, alias={"to_s"})
    public RubyString package_name() {
        return this.getRuntime().newString(this.packageName);
    }

    @Override
    public RubyString to_s() {
        return this.package_name();
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(obj == this || this.isInstance(obj));
    }

    @JRubyMethod(name={"const_missing"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject const_missing(ThreadContext context, IRubyObject name2) {
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @JRubyMethod(name={"const_get"}, required=1)
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2) {
        IRubyObject constant = this.getConstantNoConstMissing(name2.toString(), false, false);
        if (constant != null) {
            return constant;
        }
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @JRubyMethod(name={"const_get"}, required=2)
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2, IRubyObject inherit) {
        IRubyObject constant = this.getConstantNoConstMissing(name2.toString(), inherit.isTrue(), false);
        if (constant != null) {
            return constant;
        }
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    public final IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    @Override
    public final boolean hasConstant(String name2) {
        return this.constantTableContains(name2);
    }

    @Override
    public final IRubyObject fetchConstant(String name2, boolean includePrivate) {
        RubyModule.ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            throw this.getRuntime().newNameError("private constant " + this.getName() + "::" + name2 + " referenced", name2);
        }
        return entry.value;
    }

    @Override
    public final IRubyObject deleteConstant(String name2) {
        assert (name2 != null) : "name is null";
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    final CharSequence packageRelativeName(CharSequence name2) {
        int length2 = this.packageName.length();
        StringBuilder fullName = new StringBuilder(length2 + 1 + name2.length());
        fullName.append(this.packageName);
        if (length2 > 0) {
            fullName.append('.');
        }
        return fullName.append(name2);
    }

    private RubyModule relativeJavaClassOrPackage(ThreadContext context, IRubyObject name2, boolean cacheMethod) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), cacheMethod);
    }

    RubyModule relativeJavaProxyClass(Ruby runtime2, IRubyObject name2) {
        String fullName = this.packageRelativeName(name2.toString()).toString();
        JavaClass javaClass = JavaClass.forNameVerbose(runtime2, fullName);
        return Java.getProxyClass(runtime2, javaClass);
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to(context, name2, false);
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to(context, name2, includePrivate.isTrue());
    }

    private IRubyObject respond_to(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        RubySymbol name2 = TypeConverter.checkID(mname);
        if (this.getMetaClass().respondsToMethod(name2.idString(), !includePrivate)) {
            return context.tru;
        }
        return context.nil;
    }

    private RubyBoolean checkMetaClassBoundMethod(ThreadContext context, String name2, boolean includePrivate) {
        DynamicMethod method2 = this.getMetaClass().searchMethod(name2);
        if (!method2.isUndefined() && !method2.isNotImplemented()) {
            if (!includePrivate && method2.getVisibility() == Visibility.PRIVATE) {
                return context.fals;
            }
            return context.tru;
        }
        return null;
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to_missing(context, name2, false);
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to_missing(context, name2, includePrivate.isTrue());
    }

    private RubyBoolean respond_to_missing(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        return context.runtime.newBoolean(BlankSlateWrapper.handlesMethod(TypeConverter.checkID(mname).idString()) == null);
    }

    @JRubyMethod(name={"method_missing"}, visibility=Visibility.PRIVATE)
    public IRubyObject method_missing(ThreadContext context, IRubyObject name2) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), true);
    }

    @JRubyMethod(name={"method_missing"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject method_missing(ThreadContext context, IRubyObject[] args2) {
        if (args2.length > 1) {
            throw JavaPackage.packageMethodArgumentMismatch(context.runtime, this, args2[0].toString(), args2.length - 1);
        }
        return this.method_missing(context, args2[0]);
    }

    static RaiseException packageMethodArgumentMismatch(Ruby runtime2, RubyModule pkg, String method2, int argsLength) {
        String packageName = ((JavaPackage)pkg).packageName;
        return runtime2.newArgumentError("Java package '" + packageName + "' does not have a method `" + method2 + "' with " + argsLength + (argsLength == 1 ? " argument" : " arguments"));
    }

    public final boolean isAvailable() {
        return Package.getPackage(this.packageName) != null;
    }

    @JRubyMethod(name={"available?"})
    public IRubyObject available_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isAvailable());
    }

    @JRubyMethod(name={"sealed?"})
    public IRubyObject sealed_p(ThreadContext context) {
        Package pkg = Package.getPackage(this.packageName);
        if (pkg == null) {
            return context.nil;
        }
        return context.runtime.newBoolean(pkg.isSealed());
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target.isAssignableFrom(Package.class)) {
            return target.cast(Package.getPackage(this.packageName));
        }
        return super.toJava(target);
    }

    static final class BlankSlateWrapper
    extends IncludedModuleWrapper {
        BlankSlateWrapper(Ruby runtime2, RubyClass superClass, RubyModule delegate) {
            super(runtime2, superClass, delegate);
        }

        @Override
        protected DynamicMethod searchMethodCommon(String id2) {
            return (id2 = BlankSlateWrapper.handlesMethod(id2)) != null ? this.superClass.searchMethodInner(id2) : NullMethod.INSTANCE;
        }

        private static String handlesMethod(String name2) {
            switch (name2) {
                case "class": 
                case "singleton_class": {
                    return name2;
                }
                case "object_id": 
                case "name": {
                    return name2;
                }
                case "const_set": {
                    return name2;
                }
                case "inspect": 
                case "to_s": {
                    return name2;
                }
                case "throw": 
                case "catch": {
                    return name2;
                }
                case "singleton_method_added": 
                case "singleton_method_undefined": 
                case "singleton_method_removed": 
                case "define_singleton_method": {
                    return name2;
                }
                case "__constants__": {
                    return "constants";
                }
                case "__methods__": {
                    return "methods";
                }
            }
            int last2 = name2.length() - 1;
            if (last2 >= 0) {
                switch (name2.charAt(last2)) {
                    case '!': 
                    case '=': 
                    case '?': {
                        return name2;
                    }
                }
                switch (name2.charAt(0)) {
                    case '<': 
                    case '=': 
                    case '>': {
                        return name2;
                    }
                    case '_': {
                        if (last2 <= 0 || name2.charAt(1) != '_') break;
                        return name2;
                    }
                }
            }
            return null;
        }

        @Override
        public void addSubclass(RubyClass subclass) {
        }
    }

    private static class JavaClassProvider
    implements ClassProvider {
        static final JavaClassProvider INSTANCE = new JavaClassProvider();

        private JavaClassProvider() {
        }

        @Override
        public RubyClass defineClassUnder(RubyModule pkg, String name2, RubyClass superClazz) {
            if (superClazz != null) {
                return null;
            }
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Ruby runtime2 = pkg.getRuntime();
            JavaClass javaClass = JavaClass.forNameVerbose(runtime2, subPackageName);
            return (RubyClass)Java.getProxyClass(runtime2, javaClass);
        }

        @Override
        public RubyModule defineModuleUnder(RubyModule pkg, String name2) {
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Ruby runtime2 = pkg.getRuntime();
            JavaClass javaClass = JavaClass.forNameVerbose(runtime2, subPackageName);
            return Java.getInterfaceModule(runtime2, javaClass);
        }
    }
}

