/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.loader;

import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class FactoryHelper {
    private static final boolean DEBUG = false;

    public static XSingleServiceFactory getServiceFactory(Class<?> implClass, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        Factory xSingleServiceFactory = null;
        try {
            Field serviceName;
            try {
                serviceName = implClass.getField("__serviceName");
            }
            catch (NoSuchFieldException noSuchFieldExceptio) {
                serviceName = implClass.getField("serviceName");
            }
            xSingleServiceFactory = new Factory(implClass, (String)serviceName.get(null), multiFactory, regKey);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println("##### FactoryHelper.getServiceFactory - exception:" + noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("##### FactoryHelper.getServiceFactory - exception:" + illegalAccessException);
        }
        return xSingleServiceFactory;
    }

    public static XSingleServiceFactory getServiceFactory(Class<?> implClass, String serviceName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        return new Factory(implClass, serviceName, multiFactory, regKey);
    }

    public static Object createComponentFactory(Class<?> implClass, String serviceName) {
        return new Factory(implClass, serviceName, null, null);
    }

    public static boolean writeRegistryServiceInfo(String implName, String serviceName, XRegistryKey regKey) {
        boolean result = false;
        try {
            XRegistryKey newKey = regKey.createKey("/" + implName + "/UNO/SERVICES");
            newKey.createKey(serviceName);
            result = true;
        }
        catch (Exception ex) {
            System.err.println(">>>Connection_Impl.writeRegistryServiceInfo " + ex);
        }
        return result;
    }

    public static boolean writeRegistryServiceInfo(String impl_name, String[] supported_services, XRegistryKey xKey) {
        try {
            XRegistryKey xNewKey = xKey.createKey("/" + impl_name + "/UNO/SERVICES");
            for (int nPos = 0; nPos < supported_services.length; ++nPos) {
                xNewKey.createKey(supported_services[nPos]);
            }
            return true;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
    }

    protected static class Factory
    implements XSingleServiceFactory,
    XSingleComponentFactory,
    XServiceInfo,
    XTypeProvider {
        protected XMultiServiceFactory _xMultiServiceFactory;
        protected XRegistryKey _xRegistryKey;
        protected int _nCode;
        protected Constructor<?> _constructor;
        protected String _implName;
        protected String _serviceName;

        protected Factory(Class<?> implClass, String serviceName, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
            this._xMultiServiceFactory = xMultiServiceFactory;
            this._xRegistryKey = xRegistryKey;
            this._implName = implClass.getName();
            this._serviceName = serviceName;
            Constructor<?>[] constructors = implClass.getConstructors();
            for (int i = 0; i < constructors.length && this._constructor == null; ++i) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 3 && parameters[0].equals(XComponentContext.class) && parameters[1].equals(XRegistryKey.class) && parameters[2].equals(Object[].class)) {
                    this._nCode = 0;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 2 && parameters[0].equals(XComponentContext.class) && parameters[1].equals(XRegistryKey.class)) {
                    this._nCode = 1;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 2 && parameters[0].equals(XComponentContext.class) && parameters[1].equals(Object[].class)) {
                    this._nCode = 2;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 1 && parameters[0].equals(XComponentContext.class)) {
                    this._nCode = 3;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 3 && parameters[0].equals(XMultiServiceFactory.class) && parameters[1].equals(XRegistryKey.class) && parameters[2].equals(Object[].class)) {
                    this._nCode = 4;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 2 && parameters[0].equals(XMultiServiceFactory.class) && parameters[1].equals(XRegistryKey.class)) {
                    this._nCode = 5;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 2 && parameters[0].equals(XMultiServiceFactory.class) && parameters[1].equals(Object[].class)) {
                    this._nCode = 6;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 1 && parameters[0].equals(XMultiServiceFactory.class)) {
                    this._nCode = 7;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length == 1 && parameters[0].equals(Object[].class)) {
                    this._nCode = 8;
                    this._constructor = constructors[i];
                    continue;
                }
                if (parameters.length != 0) continue;
                this._nCode = 9;
                this._constructor = constructors[i];
            }
            if (this._constructor == null) {
                throw new RuntimeException(this.getClass().getName() + " can not find a usable constructor");
            }
        }

        private final XMultiServiceFactory getSMgr(XComponentContext xContext) {
            if (xContext != null) {
                return UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xContext.getServiceManager());
            }
            return this._xMultiServiceFactory;
        }

        @Override
        public Object createInstanceWithContext(XComponentContext xContext) throws com.sun.star.uno.Exception {
            Object[] args;
            switch (this._nCode) {
                case 0: {
                    args = new Object[]{xContext, this._xRegistryKey, new Object[0]};
                    break;
                }
                case 1: {
                    args = new Object[]{xContext, this._xRegistryKey};
                    break;
                }
                case 2: {
                    args = new Object[]{xContext, new Object[0]};
                    break;
                }
                case 3: {
                    args = new Object[]{xContext};
                    break;
                }
                case 4: {
                    args = new Object[]{this.getSMgr(xContext), this._xRegistryKey, new Object[0]};
                    break;
                }
                case 5: {
                    args = new Object[]{this.getSMgr(xContext), this._xRegistryKey};
                    break;
                }
                case 6: {
                    args = new Object[]{this.getSMgr(xContext), new Object[0]};
                    break;
                }
                case 7: {
                    args = new Object[]{this.getSMgr(xContext)};
                    break;
                }
                case 8: {
                    args = new Object[]{new Object[0]};
                    break;
                }
                default: {
                    args = new Object[]{};
                }
            }
            try {
                return this._constructor.newInstance(args);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable targetException = invocationTargetException.getCause();
                if (targetException instanceof java.lang.RuntimeException) {
                    throw (java.lang.RuntimeException)targetException;
                }
                if (targetException instanceof com.sun.star.uno.Exception) {
                    throw (com.sun.star.uno.Exception)targetException;
                }
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new com.sun.star.uno.Exception(targetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new com.sun.star.uno.Exception(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new com.sun.star.uno.Exception(instantiationException);
            }
        }

        @Override
        public Object createInstanceWithArgumentsAndContext(Object[] rArguments, XComponentContext xContext) throws com.sun.star.uno.Exception {
            Object[] args;
            boolean bInitCall = true;
            switch (this._nCode) {
                case 0: {
                    args = new Object[]{xContext, this._xRegistryKey, rArguments};
                    bInitCall = false;
                    break;
                }
                case 1: {
                    args = new Object[]{xContext, this._xRegistryKey};
                    break;
                }
                case 2: {
                    args = new Object[]{xContext, rArguments};
                    bInitCall = false;
                    break;
                }
                case 3: {
                    args = new Object[]{xContext};
                    break;
                }
                case 4: {
                    args = new Object[]{this.getSMgr(xContext), this._xRegistryKey, rArguments};
                    bInitCall = false;
                    break;
                }
                case 5: {
                    args = new Object[]{this.getSMgr(xContext), this._xRegistryKey};
                    break;
                }
                case 6: {
                    args = new Object[]{this.getSMgr(xContext), rArguments};
                    bInitCall = false;
                    break;
                }
                case 7: {
                    args = new Object[]{this.getSMgr(xContext)};
                    break;
                }
                case 8: {
                    args = new Object[]{rArguments};
                    bInitCall = false;
                    break;
                }
                default: {
                    args = new Object[]{};
                }
            }
            try {
                XInitialization xInitialization;
                Object instance = this._constructor.newInstance(args);
                if (bInitCall && (xInitialization = UnoRuntime.queryInterface(XInitialization.class, instance)) != null) {
                    xInitialization.initialize(rArguments);
                }
                return instance;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable targetException = invocationTargetException.getCause();
                if (targetException instanceof java.lang.RuntimeException) {
                    throw (java.lang.RuntimeException)targetException;
                }
                if (targetException instanceof com.sun.star.uno.Exception) {
                    throw (com.sun.star.uno.Exception)targetException;
                }
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new com.sun.star.uno.Exception(targetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new com.sun.star.uno.Exception(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new com.sun.star.uno.Exception(instantiationException);
            }
        }

        @Override
        public Object createInstance() throws com.sun.star.uno.Exception, RuntimeException {
            return this.createInstanceWithContext(null);
        }

        @Override
        public Object createInstanceWithArguments(Object[] args) throws com.sun.star.uno.Exception, RuntimeException {
            return this.createInstanceWithArgumentsAndContext(args, null);
        }

        @Override
        public String[] getSupportedServiceNames() throws RuntimeException {
            return new String[]{this._serviceName};
        }

        @Override
        public String getImplementationName() throws RuntimeException {
            return this._implName;
        }

        @Override
        public boolean supportsService(String serviceName) throws RuntimeException {
            String[] services = this.getSupportedServiceNames();
            boolean found = false;
            for (int i = 0; i < services.length && !found; ++i) {
                found = services[i].equals(serviceName);
            }
            return found;
        }

        @Override
        public byte[] getImplementationId() {
            return new byte[0];
        }

        @Override
        public Type[] getTypes() {
            Type[] t = new Type[]{new Type(XSingleServiceFactory.class), new Type(XSingleComponentFactory.class), new Type(XServiceInfo.class), new Type(XTypeProvider.class)};
            return t;
        }
    }
}

