/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static boolean debug = false;
    private Map[] mimetypes;

    public MimetypesFileTypeMap() {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        try (FileReader in = null;){
            in = new FileReader(mimeTypeFileName);
            this.init(in);
        }
    }

    public MimetypesFileTypeMap(InputStream is) {
        this.init(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Reader in) {
        List systemResources;
        int len;
        this.mimetypes = new Map[5];
        for (int i = 0; i < this.mimetypes.length; ++i) {
            this.mimetypes[i] = new HashMap();
        }
        if (in != null) {
            if (debug) {
                System.out.println("MimetypesFileTypeMap: load PROG");
            }
            try {
                this.parse(this.mimetypes[0], in);
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load HOME");
        }
        try {
            String home = System.getProperty("user.home");
            if (home != null) {
                this.parseFile(this.mimetypes[1], new StringBuffer(home).append(File.separatorChar).append(".mime.types").toString());
            }
        }
        catch (SecurityException home) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load SYS");
        }
        try {
            this.parseFile(this.mimetypes[2], new StringBuffer(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mime.types").toString());
        }
        catch (SecurityException home) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load JAR");
        }
        if ((len = (systemResources = this.getSystemResources("META-INF/mime.types")).size()) > 0) {
            for (int i = 0; i < len; ++i) {
                InputStreamReader urlIn = null;
                URL url = (URL)systemResources.get(i);
                try {
                    urlIn = new InputStreamReader(url.openStream());
                    this.parse(this.mimetypes[3], urlIn);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    if (urlIn != null) {
                        try {
                            ((Reader)urlIn).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            this.parseResource(this.mimetypes[3], "/META-INF/mime.types");
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load DEF");
        }
        this.parseResource(this.mimetypes[4], "/META-INF/mimetypes.default");
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (debug) {
            System.out.println("MimetypesFileTypeMap: add to PROG");
        }
        try {
            this.parse(this.mimetypes[0], new StringReader(mime_types));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    @Override
    public synchronized String getContentType(String filename) {
        int di = filename.lastIndexOf(46);
        if (di < 0) {
            return DEFAULT_MIME_TYPE;
        }
        String tail = filename.substring(di + 1);
        if (tail.length() < 1) {
            return DEFAULT_MIME_TYPE;
        }
        for (int i = 0; i < this.mimetypes.length; ++i) {
            String mimeType = (String)this.mimetypes[i].get(tail);
            if (mimeType == null) continue;
            return mimeType;
        }
        return DEFAULT_MIME_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(Map mimetypes, String filename) {
        FileReader in = null;
        try {
            in = new FileReader(filename);
            this.parse(mimetypes, in);
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResource(Map mimetypes, String name) {
        Reader in = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                in = new InputStreamReader(is);
                this.parse(mimetypes, in);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Map mimetypes, Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        StringBuffer buf = null;
        String line = br.readLine();
        while (line != null) {
            int len = (line = line.trim()).length();
            if (len != 0 && line.charAt(0) != '#') {
                if (line.charAt(len - 1) == '\\') {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(line.substring(0, len - 1));
                } else if (buf != null) {
                    buf.append(line);
                    this.parseEntry(mimetypes, buf.toString());
                    buf = null;
                } else {
                    this.parseEntry(mimetypes, line);
                }
            }
            line = br.readLine();
        }
    }

    private void parseEntry(Map mimetypes, String line) {
        String mimeType = null;
        char[] chars = line.toCharArray();
        int len = chars.length;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (mimeType == null) {
                    mimeType = buffer.toString();
                } else if (buffer.length() > 0) {
                    mimetypes.put(buffer.toString(), mimeType);
                }
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            mimetypes.put(buffer.toString(), mimeType);
        }
    }

    private List getSystemResources(String name) {
        ArrayList<URL> acc = new ArrayList<URL>();
        try {
            Enumeration<URL> i = ClassLoader.getSystemResources(name);
            while (i.hasMoreElements()) {
                acc.add(i.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return acc;
    }

    static {
        try {
            String d = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(d);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

