/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class SearchScript
implements ScorerAware,
ExecutableScript {
    private final Map<String, Object> params;
    private final SearchLookup lookup;
    private final LeafReaderContext leafContext;
    private final LeafSearchLookup leafLookup;
    private Scorer scorer;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("search", Factory.class);
    public static final ScriptContext<Factory> AGGS_CONTEXT = new ScriptContext<Factory>("aggs", Factory.class);
    public static final ScriptContext<Factory> SCRIPT_SORT_CONTEXT = new ScriptContext<Factory>("sort", Factory.class);
    public static final ScriptContext<Factory> TERMS_SET_QUERY_CONTEXT = new ScriptContext<Factory>("terms_set", Factory.class);

    public SearchScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.params = params;
        this.lookup = lookup;
        this.leafContext = leafContext;
        this.leafLookup = leafContext == null ? null : lookup.getLeafSearchLookup(leafContext);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    protected final LeafSearchLookup getLeafLookup() {
        return this.leafLookup;
    }

    protected final LeafReaderContext getLeafContext() {
        return this.leafContext;
    }

    public final LeafDocLookup getDoc() {
        return this.leafLookup == null ? null : this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        if (this.leafLookup != null) {
            this.leafLookup.setDocument(docid);
        }
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public double getScore() {
        if (this.scorer == null) {
            return 0.0;
        }
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    public void setNextAggregationValue(Object value) {
        this.setNextVar("_value", value);
    }

    @Override
    public void setNextVar(String field, Object value) {
    }

    public long runAsLong() {
        throw new UnsupportedOperationException("runAsLong is not implemented");
    }

    @Override
    public Object run() {
        return this.runAsDouble();
    }

    public abstract double runAsDouble();

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public SearchScript newInstance(LeafReaderContext var1) throws IOException;

        public boolean needs_score();
    }
}

