/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;

public abstract class Normalizable
implements ToXContentObject {
    private final String indexName;
    private boolean hadBigNormalizedUpdate;

    public Normalizable(String indexName) {
        this.indexName = Objects.requireNonNull(indexName);
    }

    public abstract String getId();

    abstract boolean isContainerOnly();

    abstract Level getLevel();

    abstract String getPartitionFieldName();

    abstract String getPartitionFieldValue();

    abstract String getPersonFieldName();

    abstract String getFunctionName();

    abstract String getValueFieldName();

    abstract double getProbability();

    abstract double getNormalizedScore();

    abstract void setNormalizedScore(double var1);

    abstract List<ChildType> getChildrenTypes();

    abstract List<Normalizable> getChildren();

    abstract List<Normalizable> getChildren(ChildType var1);

    abstract boolean setMaxChildrenScore(ChildType var1, double var2);

    abstract void setParentScore(double var1);

    public boolean hadBigNormalizedUpdate() {
        return this.hadBigNormalizedUpdate;
    }

    public void resetBigChangeFlag() {
        this.hadBigNormalizedUpdate = false;
    }

    public void raiseBigChangeFlag() {
        this.hadBigNormalizedUpdate = true;
    }

    public String getOriginatingIndex() {
        return this.indexName;
    }

    public static enum ChildType {
        BUCKET_INFLUENCER,
        RECORD,
        PARTITION_SCORE;

    }
}

