/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.analysis.analyzer.Analyzer;
import org.elasticsearch.xpack.sql.analysis.analyzer.PreAnalyzer;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.analysis.index.MappingException;
import org.elasticsearch.xpack.sql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.sql.optimizer.Optimizer;
import org.elasticsearch.xpack.sql.parser.SqlParser;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.planner.Planner;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;

public class SqlSession {
    private final Client client;
    private final FunctionRegistry functionRegistry;
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final Optimizer optimizer;
    private final Planner planner;
    private final Configuration settings;

    public SqlSession(SqlSession other) {
        this(other.settings, other.client, other.functionRegistry, other.indexResolver, other.preAnalyzer, other.optimizer, other.planner);
    }

    public SqlSession(Configuration settings, Client client, FunctionRegistry functionRegistry, IndexResolver indexResolver, PreAnalyzer preAnalyzer, Optimizer optimizer, Planner planner) {
        this.client = client;
        this.functionRegistry = functionRegistry;
        this.indexResolver = indexResolver;
        this.preAnalyzer = preAnalyzer;
        this.optimizer = optimizer;
        this.planner = planner;
        this.settings = settings;
    }

    public FunctionRegistry functionRegistry() {
        return this.functionRegistry;
    }

    public Client client() {
        return this.client;
    }

    public Planner planner() {
        return this.planner;
    }

    public IndexResolver indexResolver() {
        return this.indexResolver;
    }

    public Optimizer optimizer() {
        return this.optimizer;
    }

    private LogicalPlan doParse(String sql, List<SqlTypedParamValue> params) {
        return new SqlParser().createStatement(sql, params);
    }

    public void analyzedPlan(LogicalPlan parsed, boolean verify, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, c -> {
            Analyzer analyzer = new Analyzer(this.functionRegistry, (IndexResolution)c, this.settings.timeZone());
            LogicalPlan p = analyzer.analyze(parsed);
            return verify ? analyzer.verify(p) : p;
        }, listener);
    }

    public void debugAnalyzedPlan(LogicalPlan parsed, ActionListener<RuleExecutor.ExecutionInfo> listener) {
        if (parsed.analyzed()) {
            listener.onResponse(null);
            return;
        }
        this.preAnalyze(parsed, r -> {
            Analyzer analyzer = new Analyzer(this.functionRegistry, (IndexResolution)r, this.settings.timeZone());
            return analyzer.debugAnalyze(parsed);
        }, listener);
    }

    private <T> void preAnalyze(LogicalPlan parsed, Function<IndexResolution, T> action, ActionListener<T> listener) {
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        if (preAnalysis.indices.size() > 1) {
            listener.onFailure((Exception)((Object)new MappingException("Queries with multiple indices are not supported", new Object[0])));
        } else if (preAnalysis.indices.size() == 1) {
            TableIdentifier table = preAnalysis.indices.get(0);
            String cluster = table.cluster();
            if (Strings.hasText((String)cluster) && !this.indexResolver.clusterName().equals(cluster)) {
                listener.onFailure((Exception)((Object)new MappingException("Cannot inspect indices in cluster/catalog [{}]", cluster)));
            }
            this.indexResolver.resolveWithSameMapping(table.index(), null, (ActionListener<IndexResolution>)ActionListener.wrap(indexResult -> listener.onResponse(action.apply((IndexResolution)indexResult)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            try {
                listener.onResponse(action.apply(IndexResolution.invalid("[none specified]")));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }
    }

    public void optimizedPlan(LogicalPlan verified, ActionListener<LogicalPlan> listener) {
        this.analyzedPlan(verified, true, (ActionListener<LogicalPlan>)ActionListener.wrap(v -> listener.onResponse((Object)this.optimizer.optimize((LogicalPlan)v)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void physicalPlan(LogicalPlan optimized, boolean verify, ActionListener<PhysicalPlan> listener) {
        this.optimizedPlan(optimized, (ActionListener<LogicalPlan>)ActionListener.wrap(o -> listener.onResponse((Object)this.planner.plan((LogicalPlan)o, verify)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void sql(String sql, List<SqlTypedParamValue> params, ActionListener<SchemaRowSet> listener) {
        this.sqlExecutable(sql, params, (ActionListener<PhysicalPlan>)ActionListener.wrap(e -> e.execute(this, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    public void sqlExecutable(String sql, List<SqlTypedParamValue> params, ActionListener<PhysicalPlan> listener) {
        try {
            this.physicalPlan(this.doParse(sql, params), true, listener);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public Configuration settings() {
        return this.settings;
    }
}

