/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class GromacsReader
extends AtomSetCollectionReader {
    protected void initializeReader() {
        this.setIsPDB();
        this.asc.newAtomSet();
        this.setModelPDB(true);
    }

    protected boolean checkLine() throws Exception {
        this.checkCurrentLineForScript();
        this.asc.setAtomSetName(this.line.trim());
        this.readAtoms();
        this.readUnitCell();
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        int modelAtomCount = this.parseIntStr(this.rd());
        for (int i = 0; i < modelAtomCount; ++i) {
            this.rd();
            int len = this.line.length();
            if (len != 44 && len != 68) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                continue;
            }
            Atom atom = new Atom();
            atom.sequenceNumber = this.parseIntRange(this.line, 0, 5);
            this.setAtomName(atom, this.parseTokenRange(this.line, 5, 9).trim(), this.line.substring(11, 15).trim());
            atom.atomSerial = this.parseIntRange(this.line, 15, 20);
            atom.x = this.parseFloatRange(this.line, 20, 28) * 10.0f;
            atom.y = this.parseFloatRange(this.line, 28, 36) * 10.0f;
            atom.z = this.parseFloatRange(this.line, 36, 44) * 10.0f;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                atom.set(0.0f, 0.0f, 0.0f);
            }
            this.setAtomCoord(atom);
            atom.elementSymbol = this.deduceElementSymbol(atom.group3, atom.atomName);
            if (!this.filterAtom(atom, i)) continue;
            atom.isHetero = false;
            this.asc.addAtom(atom);
            if (len < 69) continue;
            float vx = this.parseFloatRange(this.line, 44, 52) * 10.0f;
            float vy = this.parseFloatRange(this.line, 52, 60) * 10.0f;
            float vz = this.parseFloatRange(this.line, 60, 68) * 10.0f;
            if (Float.isNaN(vx) || Float.isNaN(vy) || Float.isNaN(vz)) continue;
            this.asc.addVibrationVector(atom.index, vx, vy, vz);
        }
    }

    private void setAtomName(Atom atom, String gname, String aname) {
        atom.atomName = aname;
        if (gname.equals("SOL") && aname.length() == 3 && "OW1;HW2;HW3".indexOf(aname) >= 0) {
            gname = "WAT";
        }
        atom.group3 = gname;
    }

    String deduceElementSymbol(String group3, String atomName) {
        if (atomName.length() <= 2 && group3.equals(atomName)) {
            return atomName;
        }
        char ch1 = atomName.length() == 4 ? atomName.charAt(0) : (char)'\u0000';
        char ch2 = atomName.charAt(atomName.length() == 4 ? 1 : 0);
        boolean isHetero = this.vwr.getJBR().isHetero(group3);
        if (Atom.isValidSymNoCase((char)ch1, (char)ch2)) {
            return isHetero || ch1 != 'H' ? "" + ch1 + ch2 : "H";
        }
        if (Atom.isValidSym1((char)ch2)) {
            return "" + ch2;
        }
        if (Atom.isValidSym1((char)ch1)) {
            return "" + ch1;
        }
        return "Xx";
    }

    private void readUnitCell() throws Exception {
        if (this.rd() == null) {
            return;
        }
        String[] tokens = this.getTokens();
        if (tokens.length < 3 || !this.doApplySymmetry) {
            return;
        }
        float a = 10.0f * this.parseFloatStr(tokens[0]);
        float b = 10.0f * this.parseFloatStr(tokens[1]);
        float c = 10.0f * this.parseFloatStr(tokens[2]);
        this.setUnitCell(a, b, c, 90.0f, 90.0f, 90.0f);
        this.setSpaceGroupName("P1");
        Atom[] atoms = this.asc.atoms;
        P3 pt = P3.new3((float)0.5f, (float)0.5f, (float)0.5f);
        int i = this.asc.ac;
        while (--i >= 0) {
            this.setAtomCoord(atoms[i]);
            atoms[i].add((T3)pt);
        }
    }
}

