/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.modifiers;

import com.ibm.icu.impl.number.Modifier;
import com.ibm.icu.impl.number.NumberStringBuilder;
import com.ibm.icu.impl.number.Properties;
import com.ibm.icu.text.NumberFormat;

public class ConstantMultiFieldModifier
extends Modifier.BaseModifier
implements Modifier.AffixModifier {
    public static final ConstantMultiFieldModifier EMPTY = new ConstantMultiFieldModifier();
    private final char[] prefixChars;
    private final char[] suffixChars;
    private final NumberFormat.Field[] prefixFields;
    private final NumberFormat.Field[] suffixFields;
    private final String prefix;
    private final String suffix;
    private final boolean strong;

    public ConstantMultiFieldModifier(NumberStringBuilder prefix, NumberStringBuilder suffix, boolean strong) {
        this.prefixChars = prefix.toCharArray();
        this.suffixChars = suffix.toCharArray();
        this.prefixFields = prefix.toFieldArray();
        this.suffixFields = suffix.toFieldArray();
        this.prefix = new String(this.prefixChars);
        this.suffix = new String(this.suffixChars);
        this.strong = strong;
    }

    private ConstantMultiFieldModifier() {
        this.prefixChars = new char[0];
        this.suffixChars = new char[0];
        this.prefixFields = new NumberFormat.Field[0];
        this.suffixFields = new NumberFormat.Field[0];
        this.prefix = "";
        this.suffix = "";
        this.strong = false;
    }

    @Override
    public int apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
        int length = output.insert(rightIndex, this.suffixChars, this.suffixFields);
        return length += output.insert(leftIndex, this.prefixChars, this.prefixFields);
    }

    @Override
    public int length() {
        return this.prefixChars.length + this.suffixChars.length;
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public boolean contentEquals(NumberStringBuilder prefix, NumberStringBuilder suffix) {
        return prefix.contentEquals(this.prefixChars, this.prefixFields) && suffix.contentEquals(this.suffixChars, this.suffixFields);
    }

    public String toString() {
        return String.format("<ConstantMultiFieldModifier(%d) prefix:'%s' suffix:'%s'>", this.length(), this.prefix, this.suffix);
    }

    @Override
    public void export(Properties properties) {
        throw new UnsupportedOperationException();
    }
}

