/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DependenciesCollector;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateUnboundSymbolsAsDependencies", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "DependencyGenerationTask", "ir.tree"})
public final class ExternalDependenciesGenerator {
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrBuiltIns irBuiltIns;

    public final void generateUnboundSymbolsAsDependencies(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull(irModule, "irModule");
        new DependencyGenerationTask(irModule).run();
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    public ExternalDependenciesGenerator(@NotNull SymbolTable symbolTable, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        Intrinsics.checkParameterIsNotNull(irBuiltIns, "irBuiltIns");
        this.symbolTable = symbolTable;
        this.irBuiltIns = irBuiltIns;
        this.stubGenerator = new DeclarationStubGenerator(this.symbolTable, IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator$DependencyGenerationTask;", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "getIrModule", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleFragments", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lkotlin/collections/HashMap;", "packageFragments", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "generateModuleStub", "collector", "Lorg/jetbrains/kotlin/ir/util/DependenciesCollector;", "moduleDescriptor", "generatePackageStub", "packageFragmentDescriptor", "topLevelDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getOrCreateModuleFragment", "getOrCreatePackageFragment", "run", "", "ir.tree"})
    private final class DependencyGenerationTask {
        private final HashMap<ModuleDescriptor, IrModuleFragment> moduleFragments;
        private final HashMap<PackageFragmentDescriptor, IrExternalPackageFragment> packageFragments;
        @NotNull
        private final IrModuleFragment irModule;

        /*
         * WARNING - void declaration
         */
        public final void run() {
            block0: while (true) {
                void $receiver$iv;
                DependenciesCollector collector2 = new DependenciesCollector();
                collector2.collectTopLevelDescriptorsForUnboundSymbols(ExternalDependenciesGenerator.this.getSymbolTable());
                if (collector2.isEmpty()) break;
                Iterable iterable = collector2.getDependencyModules();
                Collection destination$iv = this.irModule.getDependencyModules();
                Iterator iterator2 = $receiver$iv.iterator();
                while (true) {
                    void moduleDescriptor;
                    if (!iterator2.hasNext()) continue block0;
                    Object item$iv = iterator2.next();
                    ModuleDescriptor moduleDescriptor2 = (ModuleDescriptor)item$iv;
                    Collection collection = destination$iv;
                    IrModuleFragment irModuleFragment = this.generateModuleStub(collector2, (ModuleDescriptor)moduleDescriptor);
                    collection.add(irModuleFragment);
                }
                break;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrModuleFragment generateModuleStub(DependenciesCollector collector2, ModuleDescriptor moduleDescriptor) {
            void $receiver$iv;
            IrModuleFragment irModuleFragment;
            IrModuleFragment irDependencyModule = irModuleFragment = this.getOrCreateModuleFragment(moduleDescriptor);
            Iterable iterable = collector2.getPackageFragments(moduleDescriptor);
            Collection destination$iv = irDependencyModule.getExternalPackageFragments();
            for (Object item$iv : $receiver$iv) {
                void packageFragmentDescriptor;
                PackageFragmentDescriptor packageFragmentDescriptor2 = (PackageFragmentDescriptor)item$iv;
                Collection collection = destination$iv;
                IrExternalPackageFragment irExternalPackageFragment = this.generatePackageStub((PackageFragmentDescriptor)packageFragmentDescriptor, collector2.getTopLevelDescriptors((PackageFragmentDescriptor)packageFragmentDescriptor));
                collection.add(irExternalPackageFragment);
            }
            return irModuleFragment;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExternalPackageFragment generatePackageStub(PackageFragmentDescriptor packageFragmentDescriptor, Collection<? extends DeclarationDescriptor> topLevelDescriptors) {
            void $receiver$iv;
            IrExternalPackageFragment irExternalPackageFragment;
            IrExternalPackageFragment irExternalPackageFragment2 = irExternalPackageFragment = this.getOrCreatePackageFragment(packageFragmentDescriptor);
            Iterable iterable = topLevelDescriptors;
            Collection destination$iv = irExternalPackageFragment2.getDeclarations();
            for (Object item$iv : $receiver$iv) {
                void it;
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv;
                Collection collection = destination$iv;
                IrDeclaration irDeclaration = ExternalDependenciesGenerator.this.stubGenerator.generateMemberStub((DeclarationDescriptor)it);
                collection.add(irDeclaration);
            }
            PatchDeclarationParentsKt.patchDeclarationParents$default(irExternalPackageFragment2, null, 1, null);
            return irExternalPackageFragment;
        }

        /*
         * WARNING - void declaration
         */
        private final IrModuleFragment getOrCreateModuleFragment(ModuleDescriptor moduleDescriptor) {
            IrModuleFragment irModuleFragment;
            Map $receiver$iv = this.moduleFragments;
            Object value$iv = $receiver$iv.get(moduleDescriptor);
            if (value$iv == null) {
                IrModuleFragment answer$iv = ExternalDependenciesGenerator.this.stubGenerator.generateEmptyModuleFragmentStub(moduleDescriptor, ExternalDependenciesGenerator.this.getIrBuiltIns());
                $receiver$iv.put(moduleDescriptor, answer$iv);
                irModuleFragment = answer$iv;
            } else {
                void var3_3;
                irModuleFragment = var3_3;
            }
            return irModuleFragment;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExternalPackageFragment getOrCreatePackageFragment(PackageFragmentDescriptor packageFragmentDescriptor) {
            IrExternalPackageFragment irExternalPackageFragment;
            Map $receiver$iv = this.packageFragments;
            Object value$iv = $receiver$iv.get(packageFragmentDescriptor);
            if (value$iv == null) {
                IrExternalPackageFragment answer$iv = ExternalDependenciesGenerator.this.stubGenerator.generateEmptyExternalPackageFragmentStub(packageFragmentDescriptor);
                $receiver$iv.put(packageFragmentDescriptor, answer$iv);
                irExternalPackageFragment = answer$iv;
            } else {
                void var3_3;
                irExternalPackageFragment = var3_3;
            }
            return irExternalPackageFragment;
        }

        @NotNull
        public final IrModuleFragment getIrModule() {
            return this.irModule;
        }

        public DependencyGenerationTask(@NotNull IrModuleFragment irModule) {
            Intrinsics.checkParameterIsNotNull(irModule, "irModule");
            this.irModule = irModule;
            this.moduleFragments = new HashMap();
            this.packageFragments = new HashMap();
        }
    }
}

