/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.opengl.util.av.AudioSink;
import java.nio.ByteBuffer;

public class NullAudioSink
implements AudioSink {
    private volatile float playSpeed = 1.0f;
    private volatile boolean playRequested = false;
    private volatile int playingPTS = Integer.MIN_VALUE;
    private float volume = 1.0f;
    private AudioSink.AudioFormat chosenFormat = null;
    private boolean initialized = true;

    public boolean isInitialized() {
        return this.initialized;
    }

    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    public final boolean setPlaySpeed(float f) {
        if (Math.abs(1.0f - f) < 0.01f) {
            f = 1.0f;
        }
        this.playSpeed = f;
        return true;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final boolean setVolume(float f) {
        this.volume = f;
        return true;
    }

    public AudioSink.AudioFormat getPreferredFormat() {
        return DefaultFormat;
    }

    public final int getMaxSupportedChannels() {
        return 8;
    }

    public final boolean isSupported(AudioSink.AudioFormat audioFormat) {
        return true;
    }

    public boolean init(AudioSink.AudioFormat audioFormat, float f, int n, int n2, int n3) {
        this.chosenFormat = audioFormat;
        return true;
    }

    public final AudioSink.AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    public boolean isPlaying() {
        return this.playRequested;
    }

    public void play() {
        this.playRequested = true;
    }

    public void pause() {
        this.playRequested = false;
    }

    public void flush() {
    }

    public void destroy() {
        this.initialized = false;
        this.chosenFormat = null;
    }

    public final int getEnqueuedFrameCount() {
        return 0;
    }

    public int getFrameCount() {
        return 0;
    }

    public int getQueuedFrameCount() {
        return 0;
    }

    public int getQueuedByteCount() {
        return 0;
    }

    public int getQueuedTime() {
        return 0;
    }

    public final int getPTS() {
        return this.playingPTS;
    }

    public int getFreeFrameCount() {
        return 1;
    }

    public AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        if (!this.initialized || null == this.chosenFormat) {
            return null;
        }
        this.playingPTS = n;
        return null;
    }
}

