/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.InputSource;

public final class InputLocation
implements Serializable,
Cloneable,
InputLocationTracker {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private InputSource source;
    private Map<Object, InputLocation> locations;

    public InputLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public InputLocation(int lineNumber, int columnNumber, InputSource source2) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source2;
    }

    public InputLocation clone() {
        try {
            InputLocation copy2 = (InputLocation)super.clone();
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public Map<Object, InputLocation> getLocations() {
        return this.locations;
    }

    public InputSource getSource() {
        return this.source;
    }

    public static InputLocation merge(InputLocation target, InputLocation source2, boolean sourceDominant) {
        Map<Object, InputLocation> locations;
        if (source2 == null) {
            return target;
        }
        if (target == null) {
            return source2;
        }
        InputLocation result = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source2.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        result.setLocations(locations);
        return result;
    }

    public static InputLocation merge(InputLocation target, InputLocation source2, Collection<Integer> indices) {
        Map<Object, InputLocation> locations;
        if (source2 == null) {
            return target;
        }
        if (target == null) {
            return source2;
        }
        InputLocation result = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source2.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            for (Integer index2 : indices) {
                InputLocation location = index2 < 0 ? sourceLocations.get(~index2.intValue()) : targetLocations.get(index2);
                locations.put(locations.size(), location);
            }
        }
        result.setLocations(locations);
        return result;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    public void setLocations(Map<Object, InputLocation> locations) {
        this.locations = locations;
    }

    public String toString() {
        return this.getLineNumber() + " : " + this.getColumnNumber() + ", " + this.getSource();
    }
}

