/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.controller.actions.generated.instance.CollaborationActionBase;
import freemind.controller.actions.generated.instance.CollaborationGoodbye;
import freemind.controller.actions.generated.instance.CollaborationHello;
import freemind.controller.actions.generated.instance.CollaborationReceiveLock;
import freemind.controller.actions.generated.instance.CollaborationRequireLock;
import freemind.controller.actions.generated.instance.CollaborationTransaction;
import freemind.controller.actions.generated.instance.CollaborationUnableToLock;
import freemind.controller.actions.generated.instance.CollaborationWelcome;
import freemind.controller.actions.generated.instance.CollaborationWhoAreYou;
import freemind.controller.actions.generated.instance.CollaborationWrongCredentials;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.mindmapmode.MindMapController;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import plugins.collaboration.socket.CommunicationBase;
import plugins.collaboration.socket.MindMapMaster;
import plugins.collaboration.socket.SocketBasics;

public class ServerCommunication
extends CommunicationBase {
    protected MindMapMaster mMindMapMaster = null;

    public ServerCommunication(MindMapMaster pSocketStarter, Socket pClient, MindMapController pMindMapController) throws Exception {
        super("Client Communication", pClient, pMindMapController, new DataOutputStream(pClient.getOutputStream()), new DataInputStream(pClient.getInputStream()));
        this.mMindMapMaster = pSocketStarter;
        CollaborationWhoAreYou commandWho = new CollaborationWhoAreYou();
        this.send((CollaborationActionBase)commandWho);
        this.setCurrentState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommand(CollaborationActionBase pCommand) throws Exception {
        if (pCommand instanceof CollaborationGoodbye) {
            CollaborationGoodbye goodbye = (CollaborationGoodbye)pCommand;
            logger.info("Goodbye received from " + goodbye.getUserId());
            this.terminateSocket();
            return;
        }
        boolean commandHandled = false;
        if (pCommand instanceof CollaborationHello) {
            if (this.getCurrentState() != 1) {
                this.printWrongState(pCommand);
            } else {
                CollaborationHello commandHello = (CollaborationHello)pCommand;
                this.setName(commandHello.getUserId());
                if (this.mMindMapMaster.getPassword().equals(commandHello.getPassword())) {
                    CollaborationWelcome welcomeCommand = new CollaborationWelcome();
                    logger.info("Store map in welcome command...");
                    StringWriter writer = new StringWriter();
                    this.mController.getMap().getXml((Writer)writer);
                    welcomeCommand.setMap(writer.toString());
                    welcomeCommand.setFilename(this.mController.getMap().getFile().getName());
                    this.send((CollaborationActionBase)welcomeCommand);
                    this.setCurrentState(0);
                } else {
                    CollaborationWrongCredentials wrongMessage = new CollaborationWrongCredentials();
                    try {
                        this.send((CollaborationActionBase)wrongMessage);
                    }
                    finally {
                        this.terminateSocket();
                    }
                }
                commandHandled = true;
            }
        }
        if (pCommand instanceof CollaborationTransaction) {
            if (this.getCurrentState() != 2) {
                this.printWrongState(pCommand);
            } else {
                CollaborationTransaction trans = (CollaborationTransaction)pCommand;
                try {
                    if (!Tools.safeEquals((String)this.mMindMapMaster.getLockId(), (String)trans.getId())) {
                        logger.severe("Wrong transaction id received. Expected: " + this.mMindMapMaster.getLockId() + ", received: " + trans.getId());
                    } else {
                        this.mMindMapMaster.broadcastCommand(trans.getDoAction(), trans.getUndoAction(), trans.getId());
                        this.mMindMapMaster.executeTransaction(this.getActionPair(trans));
                    }
                }
                finally {
                    this.mMindMapMaster.unlock();
                    this.setCurrentState(0);
                    commandHandled = true;
                }
            }
        }
        if (pCommand instanceof CollaborationRequireLock) {
            if (this.getCurrentState() != 0) {
                this.printWrongState(pCommand);
            }
            try {
                String lockId = this.mMindMapMaster.lock(this.getName());
                logger.info("Got lock for " + this.getName());
                CollaborationReceiveLock lockCommand = new CollaborationReceiveLock();
                lockCommand.setId(lockId);
                this.send((CollaborationActionBase)lockCommand);
                this.setCurrentState(2);
                commandHandled = true;
            }
            catch (SocketBasics.UnableToGetLockException e) {
                Resources.getInstance().logException((Throwable)e);
                CollaborationUnableToLock unableToLock = new CollaborationUnableToLock();
                this.send((CollaborationActionBase)unableToLock);
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
        if (!commandHandled) {
            logger.warning("Received unknown message of type " + pCommand.getClass());
        }
    }

    public void terminateSocket() throws IOException {
        this.mMindMapMaster.removeConnection(this);
        this.commitSuicide();
        this.close();
    }
}

