/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerTracker;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    private volatile Identikit myIdentikit;
    protected final SmartPointerManagerImpl myManager;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project, @Nullable ProperTextRange range, @NotNull Identikit identikit, @NotNull PsiFile containingFile, boolean forInjected) {
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(0);
        }
        if (identikit == null) {
            SelfElementInfo.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            SelfElementInfo.$$$reportNull$$$0(2);
        }
        this.myForInjected = forInjected;
        this.myIdentikit = identikit;
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project);
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange(range);
    }

    void switchToAnchor(@NotNull PsiElement element) {
        Pair<Identikit.ByAnchor, PsiElement> pair;
        if (element == null) {
            SelfElementInfo.$$$reportNull$$$0(3);
        }
        if ((pair = Identikit.withAnchor(element, this.myIdentikit.getFileLanguage())) != null) {
            assert (((Identikit.ByAnchor)pair.first).hashCode() == this.myIdentikit.hashCode());
            this.myIdentikit = (Identikit)pair.first;
            this.setRange(((PsiElement)pair.second).getTextRange());
        } else {
            this.setRange(element.getTextRange());
        }
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        } else {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isGreedy() {
        return this.myForInjected || this.myIdentikit.isForPsiFile();
    }

    @Override
    Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    PsiElement restoreElement() {
        TextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file2 = this.restoreFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return this.myIdentikit.findPsiElement(file2, segment.getStartOffset(), segment.getEndOffset());
    }

    @Override
    @Nullable
    TextRange getPsiRange() {
        return this.calcPsiRange();
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myIdentikit.getFileLanguage());
    }

    @Override
    void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(@NotNull VirtualFile virtualFile2, @NotNull Project project, @NotNull Language language) {
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(5);
        }
        if (language == null) {
            SelfElementInfo.$$$reportNull$$$0(6);
        }
        return ReadAction.compute(() -> {
            if (project == null) {
                SelfElementInfo.$$$reportNull$$$0(15);
            }
            if (virtualFile2 == null) {
                SelfElementInfo.$$$reportNull$$$0(16);
            }
            if (language == null) {
                SelfElementInfo.$$$reportNull$$$0(17);
            }
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiFile file2 = PsiManager.getInstance(project).findFile(child);
            if (file2 != null) {
                return file2.getViewProvider().getPsi(language == Language.ANY ? file2.getViewProvider().getBaseLanguage() : language);
            }
            return null;
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(VirtualFile virtualFile2, @NotNull Project project) {
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(7);
        }
        if (virtualFile2 == null) {
            return null;
        }
        return ReadAction.compute(() -> {
            if (project == null) {
                SelfElementInfo.$$$reportNull$$$0(14);
            }
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiDirectory file2 = PsiManager.getInstance(project).findDirectory(child);
            if (file2 == null || !file2.isValid()) {
                return null;
            }
            return file2;
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile2) {
        VirtualFile child;
        if (virtualFile2.isValid()) {
            child = virtualFile2;
        } else {
            VirtualFile vParent = virtualFile2.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile2.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    int elementHashCode() {
        return this.getVirtualFile().hashCode() + this.myIdentikit.hashCode() * 31;
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            SelfElementInfo.$$$reportNull$$$0(8);
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myIdentikit != otherInfo.myIdentikit) {
                return false;
            }
            return ReadAction.compute(() -> {
                TextRange range1 = this.getPsiRange();
                TextRange range2 = otherInfo.getPsiRange();
                return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
            });
        }
        return false;
    }

    @Override
    @NotNull
    final VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(9);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    Segment getRange() {
        SmartPointerTracker tracker;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (tracker = this.myManager.getTracker(this.getVirtualFile())) != null) {
            return tracker.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(10);
        }
        return project;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myIdentikit;
    }

    public static Segment calcActualRangeAfterDocumentEvents(@NotNull PsiFile containingFile, @NotNull Document document, @NotNull Segment segment, boolean isSegmentGreedy) {
        SmartPointerManagerImpl pointerManager;
        SmartPointerTracker tracker;
        Project project;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        if (containingFile == null) {
            SelfElementInfo.$$$reportNull$$$0(11);
        }
        if (document == null) {
            SelfElementInfo.$$$reportNull$$$0(12);
        }
        if (segment == null) {
            SelfElementInfo.$$$reportNull$$$0(13);
        }
        if (!(events = (documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project = containingFile.getProject())).getEventsSinceCommit(document)).isEmpty() && (tracker = (pointerManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project)).getTracker(containingFile.getViewProvider().getVirtualFile())) != null) {
            return tracker.getUpdatedRange(containingFile, segment, isSegmentGreedy, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identikit";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "switchToAnchor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restoreFileFromVirtual";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreDirectoryFromVirtual";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcActualRangeAfterDocumentEvents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreDirectoryFromVirtual$1";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreFileFromVirtual$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

