/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.BasicTextResourceLoader;
import org.gradle.internal.resource.TextResource;
import org.gradle.util.NameValidator;

public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;
    private final ProjectRegistry<ProjectInternal> projectRegistry;
    private final BasicTextResourceLoader resourceLoader = new BasicTextResourceLoader();

    public ProjectFactory(Instantiator instantiator, ProjectRegistry<ProjectInternal> projectRegistry) {
        this.instantiator = instantiator;
        this.projectRegistry = projectRegistry;
    }

    @Override
    public DefaultProject createProject(ProjectDescriptor projectDescriptor, ProjectInternal parent, GradleInternal gradle, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        File buildFile = projectDescriptor.getBuildFile();
        TextResource resource = this.resourceLoader.loadFile("build file", buildFile);
        TextResourceScriptSource source = new TextResourceScriptSource(resource);
        NameValidator.validate(projectDescriptor.getName(), "project name", DefaultProjectDescriptor.INVALID_NAME_IN_INCLUDE_HINT);
        DefaultProject project = (DefaultProject)this.instantiator.newInstance(DefaultProject.class, new Object[]{projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), buildFile, source, gradle, gradle.getServiceRegistryFactory(), selfClassLoaderScope, baseClassLoaderScope});
        if (parent != null) {
            parent.addChildProject(project);
        }
        this.projectRegistry.addProject(project);
        return project;
    }
}

