/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.DefaultInstantiatorFactory;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.ResponseProtocol;

public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol,
StreamFailureHandler {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient Throwable failure;
    private transient Class<?> workerImplementation;
    private transient Object implementation;
    private InstantiatorFactory instantiatorFactory;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        try {
            if (this.instantiatorFactory == null) {
                this.instantiatorFactory = new DefaultInstantiatorFactory(new AsmBackedClassGenerator(), new CrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager()));
            }
            this.workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = this.instantiatorFactory.inject(workerProcessContext.getServiceRegistry()).newInstance(this.workerImplementation, new Object[0]);
        }
        catch (Throwable e) {
            this.failure = e;
        }
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
        CurrentBuildOperationRef.instance().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runThenStop(String methodName, Class<?>[] paramTypes, Object[] args, BuildOperationRef buildOperation) {
        try {
            this.run(methodName, paramTypes, args, buildOperation);
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String methodName, Class<?>[] paramTypes, Object[] args, BuildOperationRef buildOperation) {
        if (this.failure != null) {
            this.responder.infrastructureFailed(this.failure);
            return;
        }
        try {
            Object result;
            Method method = this.workerImplementation.getDeclaredMethod(methodName, paramTypes);
            CurrentBuildOperationRef.instance().set(buildOperation);
            try {
                result = method.invoke(this.implementation, args);
            }
            catch (InvocationTargetException e) {
                Throwable failure = e.getCause();
                if (failure instanceof NoClassDefFoundError) {
                    this.responder.infrastructureFailed(failure);
                } else {
                    this.responder.failed(failure);
                }
                CurrentBuildOperationRef.instance().clear();
                return;
            }
            this.responder.completed(result);
        }
        catch (Throwable t) {
            this.responder.infrastructureFailed(t);
        }
        finally {
            CurrentBuildOperationRef.instance().clear();
        }
    }

    public void handleStreamFailure(Throwable t) {
        this.responder.failed(t);
    }
}

