/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class CsfReader
extends MopacSlaterReader {
    private int nAtoms = 0;
    private String strAtomicNumbers = "";
    private int fieldCount;
    private int nVibrations = 0;
    private int nGaussians = 0;
    private int nSlaters = 0;
    private Map<String, Bond> htBonds;
    private Map<String, Integer> propertyItemCounts = new Hashtable<String, Integer>();
    private final int[] fieldTypes = new int[100];
    private static final byte objCls1 = 1;
    private static final byte objID1 = 2;
    private static final byte objCls2 = 3;
    private static final byte objID2 = 4;
    private static final String[] connectorFields = new String[]{"objCls1", "objID1", "objCls2", "objID2"};
    private static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4};
    private Map<String, String[]> connectors;
    private static final byte ID = -1;
    private static final byte SYM = 1;
    private static final byte ANUM = 2;
    private static final byte CHRG = 3;
    private static final byte XYZ = 4;
    private static final byte PCHRG = 5;
    private static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates", "pchrg"};
    private static final byte[] atomFieldMap = new byte[]{-1, 1, 2, 3, 4, 5};
    private static final byte BTYPE = 1;
    private static final String[] bondFields = new String[]{"ID", "type"};
    private static final byte[] bondFieldMap = new byte[]{-1, 1};
    private static final byte NORMAL_MODE = 1;
    private static final byte VIB_ENERGY = 2;
    private static final byte DIPOLE = 3;
    private static final String[] vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
    private static final byte[] vibFieldMap = new byte[]{-1, 1, 2, 3};
    private static final byte EIG_VAL = 1;
    private static final byte MO_OCC = 2;
    private static final byte EIG_VEC = 3;
    private static final byte EIG_VEC_COMPRESSED = 4;
    private static final byte COEF_INDICES = 5;
    private static final byte BFXN_ANGL = 6;
    private static final byte STO_EXP = 7;
    private static final byte CONTRACTIONS = 8;
    private static final byte GTO_EXP = 9;
    private static final byte SHELL = 10;
    private static final String[] moFields = new String[]{"ID", "eig_val", "mo_occ", "eig_vec", "eig_vec_compressed", "coef_indices", "bfxn_ang", "sto_exp", "contractions", "gto_exp", "shell"};
    private static final byte[] moFieldMap = new byte[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    protected boolean checkLine() throws Exception {
        if (this.line.equals("local_transform")) {
            this.processLocalTransform();
            return true;
        }
        if (this.line.startsWith("object_class")) {
            if (this.line.equals("object_class connector")) {
                this.processConnectorObject();
                return false;
            }
            if (this.line.equals("object_class atom")) {
                this.processAtomObject();
                return false;
            }
            if (this.line.equals("object_class bond")) {
                this.processBondObject();
                return false;
            }
            if (this.line.equals("object_class vibrational_level")) {
                this.processVibrationObject();
                return false;
            }
            if (this.line.equals("object_class mol_orbital")) {
                this.processMolecularOrbitalObject();
                return false;
            }
            if (this.line.equals("object_class sto_basis_fxn")) {
                this.processBasisObject("sto");
                return false;
            }
            if (this.line.equals("object_class gto_basis_fxn")) {
                this.processBasisObject("gto");
                return false;
            }
        }
        return true;
    }

    private void processLocalTransform() throws Exception {
        String[] tokens = PT.getTokens((String)(this.rd() + " " + this.rd() + " " + this.rd() + " " + this.rd()));
        this.setTransform(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]), this.parseFloatStr(tokens[6]), this.parseFloatStr(tokens[8]), this.parseFloatStr(tokens[9]), this.parseFloatStr(tokens[10]));
    }

    private int getPropertyCount(String what) {
        Integer count = this.propertyItemCounts.get(what);
        return what.equals("ID") ? 1 : (count == null ? 0 : count);
    }

    private int parseLineParameters(String[] fields, byte[] fieldMap) throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldTypes[i] = 0;
        }
        this.fieldCount = -1;
        if (this.line == null || this.line.startsWith("property_flags:")) {
            this.rd();
        }
        if (this.line == null || this.line.startsWith("object_class")) {
            return this.fieldCount;
        }
        String[] tokens = new String[]{};
        while (this.line != null) {
            tokens = this.getTokens();
            if (this.line.indexOf("property ") == 0) {
                this.propertyItemCounts.put(tokens[1], tokens[6].equals("STRING") ? 1 : this.parseIntStr(tokens[5]));
            } else if (this.line.indexOf("ID") == 0) break;
            this.rd();
        }
        int fpt = 0;
        for (int ipt = 0; ipt < tokens.length; ++ipt) {
            String field = tokens[ipt];
            int i = fields.length;
            while (--i >= 0) {
                if (!field.equals(fields[i])) continue;
                this.fieldTypes[fpt] = fieldMap[i];
                this.fieldCount = fpt + 1;
                break;
            }
            fpt += this.getPropertyCount(field);
        }
        return this.fieldCount;
    }

    private void fillCsfArray(String property, String[] tokens, int i0, Object f, boolean isInteger) throws Exception {
        int n = this.getPropertyCount(property);
        int ioffset = i0;
        for (int i = 0; i < n; ++i) {
            int ipt = ioffset + i;
            if (ipt == tokens.length) {
                tokens = PT.getTokens((String)this.rd());
                ioffset -= ipt - i0;
                ipt = i0;
            }
            if (isInteger) {
                ((int[])f)[i] = this.parseIntStr(tokens[ipt]);
                continue;
            }
            ((float[])f)[i] = this.parseFloatStr(tokens[ipt]);
        }
    }

    private void processConnectorObject() throws Exception {
        this.connectors = new Hashtable<String, String[]>();
        this.rd();
        this.parseLineParameters(connectorFields, connectorFieldMap);
        block6: while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String thisAtomID = null;
            String thisBondID = null;
            String[] tokens = this.getTokens();
            String field2 = "";
            boolean isVibration = false;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                String field = tokens[i];
                switch (this.fieldTypes[i]) {
                    case 1: {
                        if (field.equals("atom")) continue block7;
                        continue block6;
                    }
                    case 3: {
                        field2 = field;
                        if (field.equals("sto_basis_fxn")) {
                            ++this.nSlaters;
                            continue block7;
                        }
                        if (field.equals("gto_basis_fxn")) {
                            ++this.nGaussians;
                            continue block7;
                        }
                        if (field.equals("vibrational_level")) {
                            isVibration = true;
                            continue block7;
                        }
                        if (field.equals("bond")) continue block7;
                        continue block6;
                    }
                    case 2: {
                        thisAtomID = field;
                        continue block7;
                    }
                    case 4: {
                        thisBondID = field2 + field;
                        if (!isVibration) continue block7;
                        this.nVibrations = Math.max(this.nVibrations, this.parseIntStr(field));
                        continue block7;
                    }
                }
            }
            if (thisAtomID == null || thisBondID == null) continue;
            if (this.connectors.containsKey(thisBondID)) {
                String[] connect = this.connectors.get(thisBondID);
                connect[1] = thisAtomID;
                if (this.htBonds == null) continue;
                this.setBond(this.htBonds.get(thisBondID), connect);
                continue;
            }
            String[] connect = new String[2];
            connect[0] = thisAtomID;
            this.connectors.put(thisBondID, connect);
        }
    }

    private void setBond(Bond bond, String[] connect) {
        bond.atomIndex1 = this.asc.getAtomIndex(connect[0]);
        bond.atomIndex2 = this.asc.getAtomIndex(connect[1]);
        this.asc.addBond(bond);
    }

    private void processAtomObject() throws Exception {
        this.rd();
        this.parseLineParameters(atomFields, atomFieldMap);
        this.nAtoms = 0;
        while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String[] tokens = this.getTokens();
            Atom atom = new Atom();
            block9: for (int i = 0; i < this.fieldCount; ++i) {
                int type = this.fieldTypes[i];
                if (type == 0) continue;
                String field = tokens[i];
                if (field == null) {
                    Logger.warn((String)("field == null in " + this.line));
                }
                switch (type) {
                    case -1: {
                        atom.atomSerial = PT.parseInt((String)field);
                        continue block9;
                    }
                    case 1: {
                        atom.elementSymbol = field;
                        atom.atomName = field + atom.atomSerial;
                        continue block9;
                    }
                    case 2: {
                        this.strAtomicNumbers = this.strAtomicNumbers + field + " ";
                        continue block9;
                    }
                    case 3: {
                        atom.formalCharge = this.parseIntStr(field);
                        continue block9;
                    }
                    case 5: {
                        atom.partialCharge = this.parseFloatStr(field);
                        continue block9;
                    }
                    case 4: {
                        this.setAtomCoordTokens(atom, tokens, i);
                        i += 2;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("atom " + atom.atomName + " has invalid/unknown coordinates"));
                continue;
            }
            ++this.nAtoms;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    private void processBondObject() throws Exception {
        this.rd();
        this.parseLineParameters(bondFields, bondFieldMap);
        while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String thisBondID = null;
            String[] tokens = this.getTokens();
            block5: for (int i = 0; i < this.fieldCount; ++i) {
                String field = tokens[i];
                switch (this.fieldTypes[i]) {
                    case -1: {
                        thisBondID = "bond" + field;
                        continue block5;
                    }
                    case 1: {
                        int order = 1;
                        if (field.equals("single")) {
                            order = 1;
                        } else if (field.equals("double")) {
                            order = 2;
                        } else if (field.equals("triple")) {
                            order = 3;
                        } else {
                            Logger.warn((String)("unknown CSF bond order: " + field));
                        }
                        Bond bond = new Bond(-1, -1, 1);
                        bond.order = order;
                        if (this.connectors == null) {
                            if (this.htBonds == null) {
                                this.htBonds = new Hashtable<String, Bond>();
                            }
                            this.htBonds.put(thisBondID, bond);
                            continue block5;
                        }
                        this.setBond(bond, this.connectors.get(thisBondID));
                    }
                }
            }
        }
    }

    private void processVibrationObject() throws Exception {
        float[][] vibData = new float[this.nVibrations][this.nAtoms * 3];
        String[] energies = new String[this.nVibrations];
        this.rd();
        while (this.line != null && this.parseLineParameters(vibFields, vibFieldMap) > 0) {
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                int thisvib = -1;
                block7: for (int i = 0; i < this.fieldCount; ++i) {
                    String field = tokens[i];
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            thisvib = this.parseIntStr(field) - 1;
                            continue block7;
                        }
                        case 1: {
                            this.fillCsfArray("normalMode", tokens, i, vibData[thisvib], false);
                            continue block7;
                        }
                        case 2: {
                            energies[thisvib] = field;
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nVibrations; ++i) {
            if (!this.doGetVibration(++this.vibrationNumber)) continue;
            this.asc.cloneAtomSetWithBonds(false);
            this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, energies[i], null);
            int ipt = 0;
            int baseAtom = this.nAtoms * (i + 1);
            for (int iAtom = 0; iAtom < this.nAtoms; ++iAtom) {
                this.asc.addVibrationVector(baseAtom + iAtom, vibData[i][ipt++], vibData[i][ipt++], vibData[i][ipt++]);
            }
        }
    }

    private void processMolecularOrbitalObject() throws Exception {
        if (this.nSlaters == 0 && this.nGaussians == 0 || !this.doReadMolecularOrbitals) {
            this.rd();
            return;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        Logger.info((String)("Reading CSF data for " + this.nOrbitals + " molecular orbitals"));
        float[] energy = new float[this.nOrbitals];
        float[] occupancy = new float[this.nOrbitals];
        float[][] list = new float[this.nOrbitals][this.nOrbitals];
        float[][] listCompressed = null;
        int[][] coefIndices = null;
        int ipt = 0;
        boolean isCompressed = false;
        this.rd();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                block10: for (int i = 0; i < this.fieldCount; ++i) {
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            ipt = this.parseIntStr(tokens[i]) - 1;
                            continue block10;
                        }
                        case 1: {
                            energy[ipt] = this.parseFloatStr(tokens[i]);
                            continue block10;
                        }
                        case 2: {
                            occupancy[ipt] = this.parseFloatStr(tokens[i]);
                            continue block10;
                        }
                        case 3: {
                            this.fillCsfArray("eig_vec", tokens, i, list[ipt], false);
                            continue block10;
                        }
                        case 4: {
                            isCompressed = true;
                            if (listCompressed == null) {
                                listCompressed = new float[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("eig_vec_compressed", tokens, i, listCompressed[ipt], false);
                            continue block10;
                        }
                        case 5: {
                            if (coefIndices == null) {
                                coefIndices = new int[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("coef_indices", tokens, i, coefIndices[ipt], true);
                        }
                    }
                }
            }
        }
        for (int iMo = 0; iMo < this.nOrbitals; ++iMo) {
            if (isCompressed) {
                int pt;
                for (int i = 0; i < coefIndices[iMo].length && (pt = coefIndices[iMo][i] - 1) >= 0; ++i) {
                    list[iMo][pt] = listCompressed[iMo][i];
                }
            }
            for (int i = 0; i < this.nOrbitals; ++i) {
                if (!(Math.abs(list[iMo][i]) < 1.0E-4f)) continue;
                list[iMo][i] = 0.0f;
            }
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("energy", Float.valueOf(energy[iMo]));
            mo.put("occupancy", Float.valueOf(occupancy[iMo]));
            mo.put("coefficients", list[iMo]);
            this.setMO(mo);
        }
        this.setMOs("eV");
    }

    private void processBasisObject(String sto_gto) throws Exception {
        int i;
        int ipt;
        String[] atomNos = PT.getTokens((String)this.strAtomicNumbers);
        this.atomicNumbers = new int[atomNos.length];
        for (int i2 = 0; i2 < this.atomicNumbers.length; ++i2) {
            this.atomicNumbers[i2] = this.parseIntStr(atomNos[i2]);
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        boolean isGaussian = sto_gto.equals("gto");
        float[][] zetas = AU.newFloat2((int)this.nOrbitals);
        float[][] contractionCoefs = null;
        String[] types = new String[this.nOrbitals];
        int[] shells = new int[this.nOrbitals];
        int nZetas = 0;
        this.rd();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            if (nZetas == 0) {
                nZetas = this.getPropertyCount(sto_gto + "_exp");
            }
            ipt = 0;
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                block10: for (i = 0; i < this.fieldCount; ++i) {
                    String field = tokens[i];
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            ipt = this.parseIntStr(field) - 1;
                            continue block10;
                        }
                        case 6: {
                            types[ipt] = field;
                            continue block10;
                        }
                        case 7: 
                        case 9: {
                            zetas[ipt] = new float[nZetas];
                            this.fillCsfArray(sto_gto + "_exp", tokens, i, zetas[ipt], false);
                            continue block10;
                        }
                        case 10: {
                            shells[ipt] = this.parseIntStr(field);
                            continue block10;
                        }
                        case 8: {
                            if (contractionCoefs == null) {
                                contractionCoefs = new float[this.nOrbitals][nZetas];
                            }
                            this.fillCsfArray("contractions", tokens, i, contractionCoefs[ipt], false);
                        }
                    }
                }
            }
        }
        if (isGaussian) {
            Lst sdata = new Lst();
            Lst gdata = new Lst();
            int iShell = 0;
            int gaussianCount = 0;
            for (int ipt2 = 0; ipt2 < this.nGaussians; ++ipt2) {
                if (shells[ipt2] == iShell) continue;
                iShell = shells[ipt2];
                int[] slater = new int[4];
                int iAtom = this.asc.getAtomIndex(this.connectors.get(sto_gto + "_basis_fxn" + (ipt2 + 1))[0]);
                slater[0] = iAtom + 1;
                slater[1] = BasisFunctionReader.getQuantumShellTagID(types[ipt2].substring(0, 1));
                int nZ = 0;
                while (++nZ < nZetas && zetas[ipt2][nZ] != 0.0f) {
                }
                slater[2] = gaussianCount;
                slater[3] = nZ;
                sdata.addLast((Object)slater);
                gaussianCount += nZ;
                for (int i3 = 0; i3 < nZ; ++i3) {
                    gdata.addLast((Object)new float[]{zetas[ipt2][i3], contractionCoefs[ipt2][i3]});
                }
            }
            float[][] garray = AU.newFloat2((int)gaussianCount);
            for (int i4 = 0; i4 < gaussianCount; ++i4) {
                garray[i4] = (float[])gdata.get(i4);
            }
            this.moData.put("shells", sdata);
            this.moData.put("gaussians", garray);
        } else {
            for (ipt = 0; ipt < this.nSlaters; ++ipt) {
                int iAtom = this.asc.getAtomIndex(this.connectors.get(sto_gto + "_basis_fxn" + (ipt + 1))[0]);
                for (i = 0; i < nZetas && zetas[ipt][i] != 0.0f; ++i) {
                    this.createSphericalSlaterByType(iAtom, this.atomicNumbers[iAtom], types[ipt], zetas[ipt][i] * (float)(i == 0 ? 1 : -1), contractionCoefs == null ? 1.0f : contractionCoefs[ipt][i]);
                }
            }
            this.setSlaters(true, false);
        }
    }
}

