/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.languagemodel.LanguageModel;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.ngram.NGramUtils;
import opennlp.tools.util.StringList;

public class NGramLanguageModel
extends NGramModel
implements LanguageModel {
    private static final int DEFAULT_N = 3;
    private static final double DEFAULT_K = 1.0;
    private final int n;
    private final double k;

    public NGramLanguageModel() {
        this(3, 1.0);
    }

    public NGramLanguageModel(int n) {
        this(n, 1.0);
    }

    public NGramLanguageModel(double k) {
        this(3, k);
    }

    public NGramLanguageModel(int n, double k) {
        this.n = n;
        this.k = k;
    }

    public NGramLanguageModel(InputStream in) throws IOException {
        this(in, 3, 1.0);
    }

    public NGramLanguageModel(InputStream in, double k) throws IOException {
        this(in, 3, k);
    }

    public NGramLanguageModel(InputStream in, int n) throws IOException {
        this(in, n, 1.0);
    }

    public NGramLanguageModel(InputStream in, int n, double k) throws IOException {
        super(in);
        this.n = n;
        this.k = k;
    }

    @Override
    public double calculateProbability(StringList sample) {
        double probability = 0.0;
        if (this.size() > 0) {
            for (StringList ngram : NGramUtils.getNGrams(sample, this.n)) {
                StringList nMinusOneToken = NGramUtils.getNMinusOneTokenFirst(ngram);
                if (this.size() > 1000000) {
                    probability += Math.log(this.getStupidBackoffProbability(ngram, nMinusOneToken));
                    continue;
                }
                probability += Math.log(this.getLaplaceSmoothingProbability(ngram, nMinusOneToken));
            }
            if (Double.isNaN(probability)) {
                probability = 0.0;
            } else if (probability != 0.0) {
                probability = Math.exp(probability);
            }
        }
        return probability;
    }

    @Override
    public StringList predictNextTokens(StringList tokens) {
        double maxProb = Double.NEGATIVE_INFINITY;
        StringList token = null;
        for (StringList ngram : this) {
            int i;
            String[] sequence = new String[ngram.size() + tokens.size()];
            for (i = 0; i < tokens.size(); ++i) {
                sequence[i] = tokens.getToken(i);
            }
            for (i = 0; i < ngram.size(); ++i) {
                sequence[i + tokens.size()] = ngram.getToken(i);
            }
            StringList sample = new StringList(sequence);
            double v = this.calculateProbability(sample);
            if (!(v > maxProb)) continue;
            maxProb = v;
            token = ngram;
        }
        return token;
    }

    private double getLaplaceSmoothingProbability(StringList ngram, StringList nMinusOneToken) {
        return ((double)this.getCount(ngram) + this.k) / ((double)this.getCount(nMinusOneToken) + this.k * (double)this.size());
    }

    private double getStupidBackoffProbability(StringList ngram, StringList nMinusOneToken) {
        int count = this.getCount(ngram);
        if (nMinusOneToken == null || nMinusOneToken.size() == 0) {
            return count / this.size();
        }
        if (count > 0) {
            return (double)count / (double)this.getCount(nMinusOneToken);
        }
        StringList nextNgram = NGramUtils.getNMinusOneTokenLast(ngram);
        return 0.4 * this.getStupidBackoffProbability(nextNgram, NGramUtils.getNMinusOneTokenFirst(nextNgram));
    }
}

