/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.office.PropertySet;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

class NoteConverter
extends ConverterHelper {
    private PropertySet noteConfig;
    private List<Node> notes = new ArrayList<Node>();

    NoteConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, PropertySet noteConfig) {
        super(ofr, config, converter);
        this.noteConfig = noteConfig;
    }

    void handleNote(Node onode, Node hnode) {
        String sCitBodyStyle = this.noteConfig.getProperty("text:citation-body-style-name");
        Element span = this.getTextCv().createInline((Element)hnode, sCitBodyStyle);
        String sId = Misc.getAttribute(onode, "text:id");
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        this.converter.addEpubType(link, "noteref");
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:note-citation");
        if (citation == null && (citation = Misc.getChildByTagName(onode, "text:footnote-citation")) == null) {
            citation = Misc.getChildByTagName(onode, "text:endnote-citation");
        }
        if (citation != null) {
            this.getTextCv().traversePCDATA(citation, link);
        }
        this.notes.add(onode);
    }

    boolean hasNotes() {
        return this.notes.size() > 0;
    }

    Element createNoteSection(Node hnode, String sEpubType) {
        Element section = this.converter.createElement(this.converter.isHTML5() ? "section" : "div");
        hnode.appendChild(section);
        this.converter.addEpubType(section, sEpubType);
        return section;
    }

    void insertNoteHeading(Node hnode, String sHeading, String sTarget) {
        if (sHeading.length() > 0) {
            Element heading = this.converter.createElement("h1");
            hnode.appendChild(heading);
            heading.appendChild(this.converter.createTextNode(sHeading));
            if (this.config.getXhtmlSplitLevel() > 0) {
                this.converter.addContentEntry(sHeading, 1, null);
            } else {
                this.converter.addTarget(heading, sTarget);
                this.converter.addContentEntry(sHeading, 1, sTarget);
            }
        }
    }

    void flushNotes(Node hnode, String sEpubType) {
        int nSize = this.notes.size();
        for (int i = 0; i < nSize; ++i) {
            Element body;
            Node note = this.notes.get(i);
            Element aside = this.converter.createElement(this.converter.isHTML5() ? "aside" : "div");
            hnode.appendChild(aside);
            this.converter.addEpubType(aside, sEpubType);
            Element citation = Misc.getChildByTagName(note, "text:note-citation");
            if (citation == null && (citation = Misc.getChildByTagName(note, "text:footnote-citation")) == null) {
                citation = Misc.getChildByTagName(note, "text:endnote-citation");
            }
            if ((body = Misc.getChildByTagName(note, "text:note-body")) == null && (body = Misc.getChildByTagName(note, "text:footnote-body")) == null) {
                body = Misc.getChildByTagName(note, "text:endnote-body");
            }
            String sId = Misc.getAttribute(note, "text:id");
            this.converter.addTarget(aside, sId);
            this.createAnchor(sId, citation);
            this.getTextCv().traverseBlockText(body, aside);
        }
        this.notes.clear();
    }

    private void createAnchor(String sId, Node citation) {
        Element link = this.converter.createLink("body" + sId);
        String sCitStyle = this.noteConfig.getProperty("text:citation-style-name");
        StyleInfo linkInfo = new StyleInfo();
        this.getTextSc().applyStyle(sCitStyle, linkInfo);
        this.applyStyle(linkInfo, link);
        String sPrefix = this.noteConfig.getProperty("style:num-prefix");
        if (sPrefix != null) {
            link.appendChild(this.converter.createTextNode(sPrefix));
        }
        this.getTextCv().traversePCDATA(citation, link);
        String sSuffix = this.noteConfig.getProperty("style:num-suffix");
        if (sSuffix != null) {
            link.appendChild(this.converter.createTextNode(sSuffix));
        }
        Element span = this.converter.createElement("span");
        span.appendChild(link);
        span.appendChild(this.converter.createTextNode(" "));
        this.getTextCv().setAsapNode(span);
    }
}

