"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const eventLoopInspector_1 = require("../actions/eventLoopInspector");
const profilingHeap_1 = require("../actions/profilingHeap");
const profilingCpu_1 = require("../actions/profilingCpu");
const coverage_1 = require("../actions/coverage");
const metricConfig_1 = require("../utils/metricConfig");
const debug = debug_1.default('axm:actionsService');
class ActionsService {
    constructor(actionsFeature) {
        this.defaultConf = {
            profilingCpu: true,
            profilingHeap: true
        };
        this.services = new Map();
        this.services.set('eventLoopDump', new eventLoopInspector_1.default(actionsFeature));
        this.services.set('profilingCpu', new profilingCpu_1.default(actionsFeature));
        this.services.set('profilingHeap', new profilingHeap_1.default(actionsFeature));
        this.services.set('coverage', new coverage_1.default(actionsFeature));
    }
    init(config, force) {
        if (!force) {
            config = metricConfig_1.default.getConfig(config, this.defaultConf);
        }
        // init actions only if they are enabled in config
        for (let property in config) {
            if (config.hasOwnProperty(property) && config[property] !== false) {
                if (!this.services.has(property)) {
                    debug(`Action ${property} does not exist`);
                    continue;
                }
                this.services.get(property).init();
            }
        }
    }
    destroy() {
        this.services.forEach((service, serviceName) => {
            if (service.destroy && typeof service.destroy === 'function') {
                service.destroy();
            }
        });
    }
    get(name) {
        if (!this.services.has(name)) {
            debug(`Service ${name} not found !`);
            return null;
        }
        return this.services.get(name);
    }
}
exports.default = ActionsService;
//# sourceMappingURL=data:application/json;base64,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