/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.model.IOListenerManager;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.util.ProgressDialog;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyReloader {
    private static final Logger logger = LoggerFactory.getLogger(OntologyReloader.class);
    private final OWLOntology ontologyToReload;
    private final ProgressDialog dlg = new ProgressDialog();
    private final OWLModelManager modelManager;
    private final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    public OntologyReloader(OWLOntology ontologyToReload, OWLModelManager modelManager) {
        this.ontologyToReload = ontologyToReload;
        this.modelManager = modelManager;
    }

    public void reload() throws OWLOntologyCreationException {
        logger.info(LogBanner.start((String)"Reloading ontology"));
        logger.info("Reloading ontology: {}", (Object)this.ontologyToReload.getOntologyID());
        try {
            List<OWLOntologyChange> changes = this.reloadOntologyAndGetPatch();
            logger.info("Applying {} change(s) to patch ontology to reloaded ontology", (Object)changes.size());
            if (!changes.isEmpty()) {
                this.ontologyToReload.getOWLOntologyManager().applyChanges(changes);
                if (this.modelManager instanceof IOListenerManager) {
                    ((IOListenerManager)((Object)this.modelManager)).fireAfterLoadEvent(this.ontologyToReload.getOntologyID(), this.ontologyToReload.getOWLOntologyManager().getOntologyDocumentIRI(this.ontologyToReload).toURI());
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof OWLOntologyCreationException) {
                throw (OWLOntologyCreationException)t;
            }
            throw new OWLOntologyCreationException(t);
        }
    }

    private List<OWLOntologyChange> reloadOntologyAndGetPatch() throws OWLOntologyCreationException {
        ListenableFuture future = this.executorService.submit(() -> {
            try {
                List<OWLOntologyChange> list = this.performReloadAndGetPatch();
                return list;
            }
            finally {
                this.dlg.setVisible(false);
            }
        });
        this.dlg.setVisible(true);
        try {
            return (List)future.get();
        }
        catch (InterruptedException e) {
            throw new OWLOntologyCreationException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OWLOntologyCreationException) {
                throw (OWLOntologyCreationException)e.getCause();
            }
            logger.error("An error occurred whilst reloading the ontology: {}", (Object)e.getMessage(), (Object)e);
            throw new OWLOntologyCreationException((Throwable)e);
        }
    }

    private List<OWLOntologyChange> performReloadAndGetPatch() throws OWLOntologyCreationException {
        this.dlg.setMessage("Reloading ontology");
        OWLOntologyManager reloadingManager = OWLManager.createOWLOntologyManager();
        PriorityCollection iriMappers = reloadingManager.getIRIMappers();
        iriMappers.clear();
        iriMappers.add((Iterable)this.ontologyToReload.getOWLOntologyManager().getIRIMappers());
        Stopwatch sw = Stopwatch.createStarted();
        long freeMemory0 = Runtime.getRuntime().freeMemory();
        OWLOntologyManager manager = this.ontologyToReload.getOWLOntologyManager();
        for (OWLOntology o : manager.getOntologies()) {
            if (o.equals(this.ontologyToReload)) continue;
            reloadingManager.createOntology(o.getOntologyID());
            reloadingManager.setOntologyDocumentIRI(o, manager.getOntologyDocumentIRI(o));
            Set axioms = o.getAxioms(AxiomType.DECLARATION);
            logger.info("Copying {} declaration axioms from {} for reloading", (Object)axioms.size(), (Object)o.getOntologyID());
            reloadingManager.addAxioms(o, axioms);
        }
        sw.stop();
        long freeMemory1 = Runtime.getRuntime().freeMemory();
        long usedMemMb = (long)((double)(freeMemory0 - freeMemory1) / 1048576.0);
        logger.info("Copied ontologies in {} ms.  Used: {} MB", (Object)sw.elapsed(TimeUnit.MILLISECONDS), (Object)usedMemMb);
        IRI ontologyDocumentIRI = manager.getOntologyDocumentIRI(this.ontologyToReload);
        OWLOntology reloadedOntology = reloadingManager.loadOntologyFromOntologyDocument(ontologyDocumentIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OntologyReloader.generateChangesToTransferContent(reloadedOntology, this.ontologyToReload, changes);
        return changes;
    }

    private static void generateChangesToTransferContent(OWLOntology from, OWLOntology to, List<OWLOntologyChange> changeList) {
        for (OWLImportsDeclaration decl : from.getImportsDeclarations()) {
            if (to.getImportsDeclarations().contains(decl)) continue;
            changeList.add((OWLOntologyChange)new AddImport(to, decl));
        }
        for (OWLImportsDeclaration decl : to.getImportsDeclarations()) {
            if (from.getImportsDeclarations().contains(decl)) continue;
            changeList.add((OWLOntologyChange)new RemoveImport(to, decl));
        }
        for (OWLAnnotation annotation : from.getAnnotations()) {
            if (to.getAnnotations().contains(annotation)) continue;
            changeList.add((OWLOntologyChange)new AddOntologyAnnotation(to, annotation));
        }
        for (OWLAnnotation annotation : to.getAnnotations()) {
            if (from.getAnnotations().contains(annotation)) continue;
            changeList.add((OWLOntologyChange)new RemoveOntologyAnnotation(to, annotation));
        }
        for (OWLAxiom ax : from.getAxioms()) {
            if (to.containsAxiom(ax)) continue;
            changeList.add((OWLOntologyChange)new AddAxiom(to, ax));
        }
        for (OWLAxiom ax : to.getAxioms()) {
            if (from.containsAxiom(ax)) continue;
            changeList.add((OWLOntologyChange)new RemoveAxiom(to, ax));
        }
        if (!from.getOntologyID().equals((Object)to.getOntologyID())) {
            changeList.add((OWLOntologyChange)new SetOntologyID(to, from.getOntologyID()));
        }
    }
}

