/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.TLSException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;

public class TLSInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private SSLEngineManager manager;
    private int offset;
    private int start;
    private int bufSize;
    private FdInStream in;

    public TLSInStream(InStream inStream, SSLEngineManager sSLEngineManager) {
        this.in = (FdInStream)inStream;
        this.manager = sSLEngineManager;
        this.offset = 0;
        SSLSession sSLSession = this.manager.getSession();
        this.bufSize = sSLSession.getApplicationBufferSize();
        this.b = new byte[this.bufSize];
        this.start = 0;
        this.end = 0;
        this.ptr = 0;
    }

    @Override
    public final int pos() {
        return this.offset + this.ptr - this.start;
    }

    public final void startTiming() {
        this.in.startTiming();
    }

    public final void stopTiming() {
        this.in.stopTiming();
    }

    public final long kbitsPerSecond() {
        return this.in.kbitsPerSecond();
    }

    public final long timeWaited() {
        return this.in.timeWaited();
    }

    @Override
    protected final int overrun(int n, int n2, boolean bl) {
        if (n > this.bufSize) {
            throw new Exception("TLSInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.offset += this.ptr - this.start;
        this.end -= this.ptr - this.start;
        this.ptr = this.start;
        while (this.end < this.start + n) {
            int n3 = this.readTLS(this.b, this.end, this.start + this.bufSize - this.end, bl);
            if (!bl && n3 == 0) {
                return 0;
            }
            this.end += n3;
        }
        if (n * n2 > this.end - this.ptr) {
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    protected int readTLS(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = -1;
        try {
            n3 = this.manager.read(ByteBuffer.wrap(byArray, n, n2), n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n3 < 0) {
            throw new TLSException("readTLS", n3);
        }
        return n3;
    }
}

