#ifndef _EFL_UI_LAYOUT_OBJECT_EO_H_
#define _EFL_UI_LAYOUT_OBJECT_EO_H_

#ifndef _EFL_UI_LAYOUT_OBJECT_EO_CLASS_TYPE
#define _EFL_UI_LAYOUT_OBJECT_EO_CLASS_TYPE

typedef Eo Efl_Ui_Layout_Object;

#endif

#ifndef _EFL_UI_LAYOUT_OBJECT_EO_TYPES
#define _EFL_UI_LAYOUT_OBJECT_EO_TYPES


#endif
/** Elementary layout class
 *
 * @ingroup Efl_Ui_Layout_Object
 */
#define EFL_UI_LAYOUT_OBJECT_CLASS efl_ui_layout_object_class_get()

EWAPI const Efl_Class *efl_ui_layout_object_class_get(void);

/**
 * @brief The theme of this widget, defines which edje group will be used.
 *
 * Based on the type of widget ($klass), a given @c group and a @c style
 * (usually "default"), the edje group name will be formed for this object.
 *
 * Widgets that inherit from this class will call this function automatically
 * so it should not be called by applications, unless you are dealing directly
 * with a @ref Efl_Ui_Layout_Object object.
 *
 * Sets the edje group from the elementary theme that will be used as layout.
 * Note that @c style will be the new style of this object, as in an
 * @ref efl_ui_widget_style_get. As a consequence this function can only be
 * called during construction of the object, before finalize.
 *
 * If this returns @c false the widget is very likely to become
 * non-functioning.
 *
 * @param[in] obj The object.
 * @param[in] klass The class of the group, eg. "button".
 * @param[in] group The group, eg. "base".
 * @param[in] style The style to use, eg "default".
 *
 * @return Whether the style was successfully applied or not, see the values of
 * @ref Efl_Ui_Theme_Apply for more information.
 *
 * @ingroup Efl_Ui_Layout_Object
 */
EOAPI Efl_Ui_Theme_Apply efl_ui_layout_object_theme_set(Eo *obj, const char *klass, const char *group, const char *style);

EWAPI extern const Efl_Event_Description _EFL_UI_LAYOUT_OBJECT_EVENT_THEME_CHANGED;

/** Called when theme changed
 *
 * @ingroup Efl_Ui_Layout_Object
 */
#define EFL_UI_LAYOUT_OBJECT_EVENT_THEME_CHANGED (&(_EFL_UI_LAYOUT_OBJECT_EVENT_THEME_CHANGED))

#endif
