/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class Exporter
implements AutoCloseable {
    private static final Setting.AffixSetting<Boolean> ENABLED_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<String> TYPE_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"type", key -> Setting.simpleString((String)key, (v, s) -> {
        switch (v) {
            case "": 
            case "http": 
            case "local": {
                break;
            }
            default: {
                throw new IllegalArgumentException("only exporter types [http] and [local] are allowed [" + v + "] is invalid");
            }
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Boolean> USE_INGEST_PIPELINE_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"use_ingest", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Boolean> CLUSTER_ALERTS_MANAGEMENT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"cluster_alerts.management.enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<List<String>> CLUSTER_ALERTS_BLACKLIST_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"cluster_alerts.management.blacklist", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<String> INDEX_NAME_TIME_FORMAT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.name.time_format", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final String INDEX_FORMAT = "YYYY.MM.dd";
    protected final Config config;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public Exporter(Config config) {
        this.config = config;
    }

    public String name() {
        return this.config.name;
    }

    public Config config() {
        return this.config;
    }

    public boolean isSingleton() {
        return false;
    }

    public abstract ExportBulk openBulk();

    protected final boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected abstract void doClose();

    protected static DateTimeFormatter dateTimeFormatter(Config config) {
        Setting setting = INDEX_NAME_TIME_FORMAT_SETTING.getConcreteSettingForNamespace(config.name);
        String format = setting.exists(config.settings()) ? (String)setting.get(config.settings()) : INDEX_FORMAT;
        try {
            return DateTimeFormat.forPattern((String)format).withZoneUTC();
        }
        catch (IllegalArgumentException e) {
            throw new SettingsException("[" + INDEX_NAME_TIME_FORMAT_SETTING.getKey() + "] invalid index name time format: [" + format + "]", (Throwable)e);
        }
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        return Arrays.asList(USE_INGEST_PIPELINE_SETTING, CLUSTER_ALERTS_MANAGEMENT_SETTING, TYPE_SETTING, ENABLED_SETTING, INDEX_NAME_TIME_FORMAT_SETTING, CLUSTER_ALERTS_BLACKLIST_SETTING);
    }

    public static interface Factory {
        public Exporter create(Config var1);
    }

    public static class Config {
        private final String name;
        private final String type;
        private final boolean enabled;
        private final Settings settings;
        private final ClusterService clusterService;
        private final XPackLicenseState licenseState;

        public Config(String name, String type, Settings settings, ClusterService clusterService, XPackLicenseState licenseState) {
            this.name = name;
            this.type = type;
            this.settings = settings;
            this.clusterService = clusterService;
            this.licenseState = licenseState;
            this.enabled = (Boolean)ENABLED_SETTING.getConcreteSettingForNamespace(name).get(settings);
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Settings settings() {
            return this.settings;
        }

        public ClusterService clusterService() {
            return this.clusterService;
        }

        public XPackLicenseState licenseState() {
            return this.licenseState;
        }
    }
}

