/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif



#ifndef _REDUCTION_H_
#define _REDUCTION_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: mink_red.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *mink_red(matrix_TYP *G, matrix_TYP *T);

/*-------------------------------------------------------------*\
| FILE: pair_red.c 
\*-------------------------------------------------------------*/
extern void pr_red(int **G, int **T, int n);
extern matrix_TYP *pair_red(matrix_TYP *Gram, matrix_TYP *Tr);

/*-------------------------------------------------------------*\
| FILE: reduction_sort.c 
\*-------------------------------------------------------------*/
extern void reduction_sort(int **G,int **T,int n);

/*-------------------------------------------------------------*\
| FILE: short_reduce.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *short_reduce(matrix_TYP *A, matrix_TYP *SV, matrix_TYP *Trf);
extern matrix_TYP *pr_short_red(matrix_TYP *A, matrix_TYP *Trf);

#else
/*-------------------------------------------------------------*\
| FILE: mink_red.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *mink_red();

/*-------------------------------------------------------------*\
| FILE: pair_red.c 
\*-------------------------------------------------------------*/
extern void pr_red();
extern matrix_TYP *pair_red();

/*-------------------------------------------------------------*\
| FILE: reduction_sort.c 
\*-------------------------------------------------------------*/
extern void reduction_sort();

/*-------------------------------------------------------------*\
| FILE: short_reduce.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *short_reduce();
extern matrix_TYP *pr_short_red();

#endif
#endif



#ifdef __cplusplus
}
#endif

