/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.database.drivers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.io.database.drivers.MySQLDriver;
import org.gephi.io.database.drivers.SQLDriver;

public class SQLServerDriver
implements SQLDriver {
    public SQLServerDriver() {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MySQLDriver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Connection getConnection(String connectionUrl, String username, String passwd) throws SQLException {
        if (!connectionUrl.contains(";databaseName=")) {
            String dbname = connectionUrl.substring(connectionUrl.lastIndexOf(47) + 1);
            String url = connectionUrl.substring(0, connectionUrl.lastIndexOf(47));
            connectionUrl = url + ";databaseName=" + dbname;
        }
        return DriverManager.getConnection(connectionUrl, username, passwd);
    }

    @Override
    public String getPrefix() {
        return "sqlserver";
    }

    @Override
    public String toString() {
        return "SQL Server";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLServerDriver) {
            return ((SQLServerDriver)obj).getPrefix().equals(this.getPrefix());
        }
        return false;
    }

    public int hashCode() {
        return this.getPrefix().hashCode();
    }
}

