/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap = new LinkedHashMap<String, SourceMapSourceEmbedding>();
    private final K2JSCompilerPerformanceManager performanceManager = new K2JSCompilerPerformanceManager();

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    protected TranslationResult translate(@NotNull JsConfig.Reporter reporter, @NotNull List<KtFile> allKotlinFiles2, @NotNull JsAnalysisResult jsAnalysisResult, @NotNull MainCallParameters mainCallParameters, @NotNull JsConfig config) throws TranslationException {
        K2JSTranslator translator = new K2JSTranslator(config);
        IncrementalDataProvider incrementalDataProvider = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            HashMap<File, KtFile> nonCompiledSources = new HashMap<File, KtFile>(allKotlinFiles2.size());
            for (KtFile ktFile2 : allKotlinFiles2) {
                nonCompiledSources.put(VfsUtilCore.virtualToIoFile(ktFile2.getVirtualFile()), ktFile2);
            }
            Map<File, TranslationResultValue> compiledParts = incrementalDataProvider.getCompiledPackageParts();
            Object[] allSources = new File[compiledParts.size() + allKotlinFiles2.size()];
            int i = 0;
            for (File file2 : compiledParts.keySet()) {
                allSources[i++] = file2;
            }
            for (File file2 : nonCompiledSources.keySet()) {
                allSources[i++] = file2;
            }
            Arrays.sort(allSources);
            ArrayList<TranslationUnit> translationUnits = new ArrayList<TranslationUnit>();
            for (i = 0; i < allSources.length; ++i) {
                KtFile nonCompiled = (KtFile)nonCompiledSources.get(allSources[i]);
                if (nonCompiled != null) {
                    translationUnits.add(new TranslationUnit.SourceFile(nonCompiled));
                    continue;
                }
                TranslationResultValue translatedValue = compiledParts.get(allSources[i]);
                translationUnits.add(new TranslationUnit.BinaryAst(translatedValue.getBinaryAst()));
            }
            return translator.translateUnits(reporter, translationUnits, mainCallParameters, jsAnalysisResult);
        }
        CollectionsKt.sortBy(allKotlinFiles2, ktFile -> VfsUtilCore.virtualToIoFile(ktFile.getVirtualFile()));
        return translator.translate(reporter, allKotlinFiles2, mainCallParameters, jsAnalysisResult);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        TranslationResult translationResult;
        final MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        ExitCode pluginLoadResult = PluginCliParser.loadPluginsSafe(arguments2.getPluginClasspaths(), arguments2.getPluginOptions(), configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, K2JSCompiler.configureLibraries(arguments2, paths, messageCollector2));
        ContentRootsKt.addKotlinSourceRoots(configuration, arguments2.getFreeArgs());
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getOutputFile() == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(arguments2.getOutputFile());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension(outputFile));
        JsConfig config = new JsConfig(project, configuration);
        JsConfig.Reporter reporter = new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            }

            @Override
            public void warning(@NotNull String message) {
                messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, message, null);
            }
        };
        if (config.checkLibFilesAndReportErrors(reporter)) {
            return ExitCode.COMPILATION_ERROR;
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector2, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration));
        analyzerWithCompilerReport.analyzeAndReport(sourcesFiles, (Function0<? extends AnalysisResult>)((Function0)() -> TopDownAnalyzerFacadeForJS.analyzeFiles(sourcesFiles, config)));
        if (analyzerWithCompilerReport.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalysisResult analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
        assert (analysisResult2 instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult2;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult2;
        File outputPrefixFile = null;
        if (arguments2.getOutputPrefix() != null && !(outputPrefixFile = new File(arguments2.getOutputPrefix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.getOutputPrefix() + "' not found", null);
            return ExitCode.COMPILATION_ERROR;
        }
        File outputPostfixFile = null;
        if (arguments2.getOutputPostfix() != null && !(outputPostfixFile = new File(arguments2.getOutputPostfix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.getOutputPostfix() + "' not found", null);
            return ExitCode.COMPILATION_ERROR;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
            K2JSCompiler.checkDuplicateSourceFileNames(messageCollector2, sourcesFiles, config);
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.getMain());
        try {
            translationResult = this.translate(reporter, sourcesFiles, jsAnalysisResult, mainCallParameters, config);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector2);
        if (!(translationResult instanceof TranslationResult.Success)) {
            return ExitCode.COMPILATION_ERROR;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector2, configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES));
        return ExitCode.OK;
    }

    private static void checkDuplicateSourceFileNames(@NotNull MessageCollector log2, @NotNull List<KtFile> sourceFiles2, @NotNull JsConfig config) {
        if (config.getSourceMapRoots().isEmpty()) {
            return;
        }
        SourceFilePathResolver pathResolver = SourceFilePathResolver.create(config);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        HashSet<String> duplicatePaths = new HashSet<String>();
        try {
            for (KtFile sourceFile : sourceFiles2) {
                String path2 = sourceFile.getVirtualFile().getPath();
                String relativePath = pathResolver.getPathRelativeToSourceRoots(new File(sourceFile.getVirtualFile().getPath()));
                String existingPath = (String)pathMap.get(relativePath);
                if (existingPath != null) {
                    if (!duplicatePaths.add(relativePath)) continue;
                    log2.report(CompilerMessageSeverity.WARNING, "There are files with same path '" + relativePath + "', relative to source roots: '" + path2 + "' and '" + existingPath + "'. This will likely cause problems with debugger", null);
                    continue;
                }
                pathMap.put(relativePath, path2);
            }
        }
        catch (IOException e) {
            log2.report(CompilerMessageSeverity.ERROR, "IO error occurred validating source path:\n" + ExceptionUtil.getThrowableText(e), null);
        }
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector2, @NotNull List<KtFile> sourceFiles2) {
        List fileNames = CollectionsKt.map(sourceFiles2, file2 -> {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 != null) {
                return MessageUtil.virtualFileToPath(virtualFile2);
            }
            return file2.getName() + " (no virtual file)";
        });
        messageCollector2.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        String moduleKindName;
        ModuleKind moduleKind;
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getTarget() != null) assert (arguments2.getTarget() == "v5") : "Unsupported ECMA version: " + arguments2.getTarget();
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, arguments2.getSourceMapPrefix());
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List<String> sourceMapSourceRootList = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        if (!arguments2.getFriendModulesDisabled() && arguments2.getFriendModules() != null) {
            List friendPaths = ArraysKt.filterNot((Object[])arguments2.getFriendModules().split(File.pathSeparator), String::isEmpty);
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        if ((expectActualTracker = services.get(ExpectActualTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, expectActualTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join(sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @NotNull
    private static List<String> configureLibraries(@NotNull K2JSCompilerArguments arguments2, @Nullable KotlinPaths paths, @NotNull MessageCollector messageCollector2) {
        File stdlibJar;
        SmartList<String> libraries = new SmartList<String>();
        if (!arguments2.getNoStdlib() && (stdlibJar = K2JSCompiler.getLibraryFromHome(paths, (Function1<KotlinPaths, File>)((Function1)KotlinPaths::getJsStdLibJarPath), "kotlin-stdlib-js.jar", messageCollector2, "'-no-stdlib'")) != null) {
            libraries.add(stdlibJar.getAbsolutePath());
        }
        if (arguments2.getLibraries() != null) {
            libraries.addAll(ArraysKt.filterNot((Object[])arguments2.getLibraries().split(File.pathSeparator), String::isEmpty));
        }
        return libraries;
    }

    @NotNull
    private static String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector2, @NotNull K2JSCompilerArguments arguments2) {
        File commonPath = null;
        ArrayList<File> pathToRoot = new ArrayList<File>();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path2 : arguments2.getFreeArgs()) {
                File file2;
                if (commonPath == null) {
                    commonPath = file2;
                    for (file2 = new File(path2).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                        pathToRoot.add(file2);
                    }
                    Collections.reverse(pathToRoot);
                    for (int i = 0; i < pathToRoot.size(); ++i) {
                        pathToRootIndexes.put(pathToRoot.get(i), i);
                    }
                    continue;
                }
                while (file2 != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file2);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file2 = file2.getParentFile();
                }
                if (file2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String text2 = ExceptionUtil.getThrowableText(e);
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text2, null);
            return ".";
        }
        return commonPath != null ? commonPath.getPath() : ".";
    }

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js";
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
        sourceMapContentEmbeddingMap.put("always", SourceMapSourceEmbedding.ALWAYS);
        sourceMapContentEmbeddingMap.put("never", SourceMapSourceEmbedding.NEVER);
        sourceMapContentEmbeddingMap.put("inlining", SourceMapSourceEmbedding.INLINING);
    }

    private static final class K2JSCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JSCompilerPerformanceManager() {
            super("Kotlin to JS Compiler");
        }
    }
}

