/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.DynamicIncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicIncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedIncrementTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtUnaryExpression expression;
    @NotNull
    protected final AccessTranslator accessTranslator;
    @NotNull
    private final JsBlock accessBlock = new JsBlock();

    public static boolean isIncrement(IElementType operationToken) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        if (IncrementTranslator.isDynamic(context, expression2)) {
            return DynamicIncrementTranslator.doTranslate(expression2, context);
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression2)) {
            return new IntrinsicIncrementTranslator(expression2, context).translateIncrementExpression();
        }
        return new OverloadedIncrementTranslator(expression2, context).translateIncrementExpression();
    }

    protected IncrementTranslator(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression2);
        this.accessTranslator = AccessTranslationUtils.getAccessTranslator(baseExpression, this.context().innerBlock(this.accessBlock)).getCached();
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            return this.asPrefix();
        }
        return this.asPostfix();
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression result2;
        JsExpression getExpression = this.accessTranslator.translateAsGet().source(this.expression);
        JsExpression reassignment = this.variableReassignment(this.context().innerBlock(this.accessBlock), getExpression).source(this.expression);
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(reassignment));
        JsExpression getNewValue = this.accessTranslator.translateAsGet().source(this.expression);
        if (this.accessBlock.getStatements().size() == 1) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, reassignment, getNewValue);
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = getNewValue;
        }
        MetadataProperties.setSynthetic(result2, true);
        return result2;
    }

    @NotNull
    private JsExpression asPostfix() {
        JsExpression result2;
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet().source(this.expression), this.expression);
        this.accessBlock.getStatements().add(t1.assignmentStatement());
        JsExpression variableReassignment = this.variableReassignment(this.context().innerBlock(this.accessBlock), t1.reference()).source(this.expression);
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(variableReassignment.source(this.expression)));
        if (this.accessBlock.getStatements().size() == 2) {
            result2 = JsAstUtils.newSequence(Arrays.asList(t1.assignmentExpression(), variableReassignment, t1.reference()));
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = t1.reference();
        }
        MetadataProperties.setSynthetic(result2, true);
        return result2;
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull TranslationContext context, @NotNull JsExpression toCallMethodUpon) {
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(context, toCallMethodUpon);
        return this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull TranslationContext var1, @NotNull JsExpression var2);

    private static boolean isDynamic(TranslationContext context, KtUnaryExpression expression2) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2);
        assert (operationDescriptor != null);
        return DynamicCallsKt.isDynamic(operationDescriptor);
    }
}

