/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;

public class ClasspathUtil {
    public static void addUrl(URLClassLoader classLoader, Iterable<URL> classpathElements) {
        try {
            HashSet<URI> original = new HashSet<URI>();
            for (URL url : classLoader.getURLs()) {
                original.add(ClasspathUtil.toURI(url));
            }
            JavaMethod<Class<URLClassLoader>, Object> method = JavaReflectionUtil.method(URLClassLoader.class, Object.class, "addURL", new Class[]{URL.class});
            for (URL classpathElement : classpathElements) {
                if (!original.add(ClasspathUtil.toURI(classpathElement))) continue;
                method.invoke((Class<URLClassLoader>)((Object)classLoader), classpathElement);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Could not add URLs %s to class path for ClassLoader %s", classpathElements, classLoader), t);
        }
    }

    public static ClassPath getClasspath(ClassLoader classLoader) {
        final ArrayList<File> implementationClassPath = new ArrayList<File>();
        new ClassLoaderVisitor(){

            @Override
            public void visitClassPath(URL[] classPath) {
                for (URL url : classPath) {
                    if (url.getProtocol() == null || !url.getProtocol().equals("file")) continue;
                    try {
                        implementationClassPath.add(new File(ClasspathUtil.toURI(url)));
                    }
                    catch (URISyntaxException e) {
                        throw new UncheckedException(e);
                    }
                }
            }
        }.visit(classLoader);
        return DefaultClassPath.of(implementationClassPath);
    }

    public static File getClasspathForClass(String targetClassName) {
        try {
            Class<?> clazz = Class.forName(targetClassName);
            if (clazz.getClassLoader() == null) {
                return null;
            }
            return ClasspathUtil.getClasspathForClass(Class.forName(targetClassName));
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static File getClasspathForClass(Class<?> targetClass) {
        try {
            URI location;
            CodeSource codeSource = targetClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && codeSource.getLocation() != null && (location = ClasspathUtil.toURI(codeSource.getLocation())).getScheme().equals("file")) {
                return new File(location);
            }
            if (targetClass.getClassLoader() != null) {
                String resourceName = targetClass.getName().replace('.', '/') + ".class";
                URL resource = targetClass.getClassLoader().getResource(resourceName);
                if (resource != null) {
                    return ClasspathUtil.getClasspathForResource(resource, resourceName);
                }
            }
            throw new GradleException(String.format("Cannot determine classpath for class %s.", targetClass.getName()));
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static File getClasspathForResource(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            return ClasspathUtil.getClasspathForResource(ClassLoader.getSystemResource(name), name);
        }
        return ClasspathUtil.getClasspathForResource(classLoader.getResource(name), name);
    }

    public static File getClasspathForResource(URL resource, String name) {
        URI location;
        try {
            String schemeSpecificPart;
            int pos;
            location = ClasspathUtil.toURI(resource);
            String path = location.getPath();
            if (location.getScheme().equals("file")) {
                assert (path.endsWith("/" + name));
                return new File(path.substring(0, path.length() - (name.length() + 1)));
            }
            if (location.getScheme().equals("jar") && (pos = (schemeSpecificPart = location.getRawSchemeSpecificPart()).indexOf("!")) > 0) {
                assert (schemeSpecificPart.substring(pos + 1).equals("/" + name));
                URI jarFile = new URI(schemeSpecificPart.substring(0, pos));
                if (jarFile.getScheme().equals("file")) {
                    return new File(jarFile.getPath());
                }
            }
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        throw new GradleException(String.format("Cannot determine classpath for resource '%s' from location '%s'.", name, location));
    }

    private static URI toURI(URL url) throws URISyntaxException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile().replace(" ", "%20")).toURI();
            }
            catch (MalformedURLException e1) {
                throw new UncheckedException(e1);
            }
        }
    }
}

