/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class ExecutionTracker {
    private final Set<UniqueId> executedUniqueIds = ConcurrentHashMap.newKeySet();

    ExecutionTracker() {
    }

    void markExecuted(TestDescriptor testDescriptor) {
        this.executedUniqueIds.add(testDescriptor.getUniqueId());
    }

    boolean wasAlreadyExecuted(TestDescriptor testDescriptor) {
        return this.executedUniqueIds.contains(testDescriptor.getUniqueId());
    }
}

