/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.util.DeprecationLogger;

public class BroadcastingCollectionEventRegister<T>
implements CollectionEventRegister<T> {
    private ImmutableActionSet<T> addActions = ImmutableActionSet.empty();
    private ImmutableActionSet<T> removeActions = ImmutableActionSet.empty();
    private final Class<? extends T> baseType;
    private boolean baseTypeSubscribed;
    private Set<Class<?>> subscribedTypes;

    public BroadcastingCollectionEventRegister(Class<? extends T> baseType) {
        this.baseType = baseType;
    }

    @Override
    public boolean isSubscribed(Class<?> type) {
        if (this.baseTypeSubscribed) {
            return true;
        }
        if (this.subscribedTypes != null) {
            if (type == null) {
                return true;
            }
            for (Class<?> subscribedType : this.subscribedTypes) {
                if (!subscribedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public Action<T> getAddAction() {
        DeprecationLogger.nagUserOfDeprecated((String)"Internal method BroadcastingCollectionEventRegister.getAddAction()");
        return new Action<T>(){

            public void execute(T t) {
                BroadcastingCollectionEventRegister.this.fireObjectAdded(t);
            }
        };
    }

    @Override
    public ImmutableActionSet<T> getAddActions() {
        return this.addActions;
    }

    @Override
    public void fireObjectAdded(T element) {
        this.addActions.execute(element);
    }

    @Override
    public void fireObjectRemoved(T element) {
        this.removeActions.execute(element);
    }

    @Override
    public void registerEagerAddAction(Class<? extends T> type, Action<? super T> addAction) {
        this.subscribe(type);
        this.addActions = this.addActions.add(addAction);
    }

    @Override
    public void registerLazyAddAction(Action<? super T> addAction) {
        this.addActions = this.addActions.add(addAction);
    }

    @Override
    public void registerRemoveAction(Class<? extends T> type, Action<? super T> removeAction) {
        this.removeActions = this.removeActions.add(removeAction);
    }

    private void subscribe(Class<? extends T> type) {
        if (this.baseTypeSubscribed) {
            return;
        }
        if (type.equals(this.baseType)) {
            this.baseTypeSubscribed = true;
            this.subscribedTypes = null;
        } else {
            if (this.subscribedTypes == null) {
                this.subscribedTypes = new HashSet();
            }
            this.subscribedTypes.add(type);
        }
    }
}

