/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationCrossProjectConfigurator
implements CrossProjectConfigurator {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ThreadLocal<Boolean> allowExecution = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public BuildOperationCrossProjectConfigurator(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Project project(Project project, Action<? super Project> configureAction) {
        this.runProjectConfigureAction(project, configureAction);
        return project;
    }

    @Override
    public void subprojects(Iterable<Project> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.SUBPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void allprojects(Iterable<Project> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.ALLPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public Project rootProject(Project project, Action<Project> buildOperationExecutor) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.ROOT_PROJECT_DETAILS, Collections.singleton(project), buildOperationExecutor);
        return project;
    }

    private void runBlockConfigureAction(BuildOperationDescriptor.Builder details, Iterable<Project> projects, final Action<? super Project> configureAction) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new BlockConfigureBuildOperation(details, projects){

            @Override
            protected void doRunProjectConfigure(Project project) {
                BuildOperationCrossProjectConfigurator.this.runProjectConfigureAction(project, (Action<? super Project>)configureAction);
            }
        });
    }

    private void runProjectConfigureAction(final Project project, final Action<? super Project> configureAction) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new CrossConfigureProjectBuildOperation(project){

            public void run(BuildOperationContext context) {
                Actions.with((Object)project, BuildOperationCrossProjectConfigurator.this.withCrossProjectConfigurationEnabled(configureAction));
            }
        });
    }

    @Override
    public void assertCrossProjectConfigurationAllowed(String methodName, Project target) {
        if (!this.isCrossConfigurationAllowed()) {
            throw this.createIllegalStateException(methodName, target);
        }
    }

    @Override
    public <T> Action<T> withCrossProjectConfigurationDisabled(Action<? super T> action) {
        return this.executeActionWithMutation(action, false);
    }

    public <T> Action<T> withCrossProjectConfigurationEnabled(Action<? super T> action) {
        return this.executeActionWithMutation(action, true);
    }

    private <T> Action<T> executeActionWithMutation(final Action<? super T> action, final boolean allowMutationMethods) {
        return new Action<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(T t) {
                boolean save = (Boolean)BuildOperationCrossProjectConfigurator.this.allowExecution.get();
                BuildOperationCrossProjectConfigurator.this.allowExecution.set(allowMutationMethods);
                try {
                    action.execute(t);
                }
                finally {
                    BuildOperationCrossProjectConfigurator.this.allowExecution.set(save);
                }
            }
        };
    }

    private IllegalStateException createIllegalStateException(String methodName, Project target) {
        return new IllegalCrossProjectConfigurationException(String.format("%s on %s cannot be executed in the current context.", methodName, target));
    }

    private boolean isCrossConfigurationAllowed() {
        return this.allowExecution.get();
    }

    private static abstract class CrossConfigureProjectBuildOperation
    implements RunnableBuildOperation {
        private Project project;

        private CrossConfigureProjectBuildOperation(Project project) {
            this.project = project;
        }

        public BuildOperationDescriptor.Builder description() {
            String name = "Cross-configure project " + ((ProjectInternal)this.project).getIdentityPath().toString();
            return BuildOperationDescriptor.displayName((String)name);
        }
    }

    private static abstract class BlockConfigureBuildOperation
    implements RunnableBuildOperation {
        private static final String ALLPROJECTS = "allprojects";
        private static final String SUBPROJECTS = "subprojects";
        private static final String ROOTPROJECT = "rootProject";
        private static final BuildOperationDescriptor.Builder ALLPROJECTS_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("allprojects");
        private static final BuildOperationDescriptor.Builder SUBPROJECTS_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("subprojects");
        private static final BuildOperationDescriptor.Builder ROOT_PROJECT_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("rootProject");
        private final BuildOperationDescriptor.Builder details;
        private final Iterable<Project> projects;

        private BlockConfigureBuildOperation(BuildOperationDescriptor.Builder details, Iterable<Project> projects) {
            this.details = details;
            this.projects = projects;
        }

        private static BuildOperationDescriptor.Builder computeConfigurationBlockBuildOperationDetails(String configurationBlockName) {
            return BuildOperationDescriptor.displayName((String)("Execute '" + configurationBlockName + " {}' action")).name(configurationBlockName);
        }

        public BuildOperationDescriptor.Builder description() {
            return this.details;
        }

        public void run(BuildOperationContext context) {
            for (Project project : this.projects) {
                this.doRunProjectConfigure(project);
            }
        }

        abstract void doRunProjectConfigure(Project var1);
    }

    @Contextual
    private static class IllegalCrossProjectConfigurationException
    extends IllegalStateException {
        public IllegalCrossProjectConfigurationException(String message) {
            super(message);
        }
    }
}

