/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.collect.Maps;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.gradle.api.internal.project.antbuilder.CacheEntry;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.Cleanup;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;

class FinalizerThread
extends Thread {
    private static final Logger LOG = Logging.getLogger(FinalizerThread.class);
    private final ReferenceQueue<CachedClassLoader> referenceQueue;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Lock lock;
    private final Map<ClassPath, Cleanup> cleanups;
    private final Map<ClassPath, CacheEntry> cacheEntries;

    public FinalizerThread(Map<ClassPath, CacheEntry> cacheEntries, Lock lock) {
        this.setName("Classloader cache reference queue poller");
        this.setDaemon(true);
        this.referenceQueue = new ReferenceQueue();
        this.cacheEntries = cacheEntries;
        this.cleanups = Maps.newConcurrentMap();
        this.lock = lock;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped.get()) {
                Cleanup entry = (Cleanup)this.referenceQueue.remove();
                ClassPath key = entry.getKey();
                this.removeCacheEntry(key, entry, Cleanup.Mode.DONT_CLOSE_CLASSLOADER);
            }
        }
        catch (InterruptedException ex) {
            LOG.debug("Shutdown of classloader cache in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheEntry(ClassPath key, Cleanup entry, Cleanup.Mode mode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing classloader from cache, classpath = {}", (Object)key.getAsURIs());
        }
        this.lock.lock();
        try {
            this.cacheEntries.remove(key);
            this.cleanups.remove(key);
        }
        finally {
            this.lock.unlock();
        }
        try {
            entry.clear();
            entry.cleanup(mode);
        }
        catch (Exception ex) {
            LOG.error("Unable to perform cleanup of classloader for classpath: " + key, (Throwable)ex);
        }
    }

    public ReferenceQueue<CachedClassLoader> getReferenceQueue() {
        return this.referenceQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        this.stopped.set(true);
        this.interrupt();
        this.lock.lock();
        try {
            while (!this.cleanups.isEmpty()) {
                Map.Entry<ClassPath, Cleanup> entry = this.cleanups.entrySet().iterator().next();
                this.removeCacheEntry(entry.getKey(), entry.getValue(), Cleanup.Mode.CLOSE_CLASSLOADER);
            }
            LOG.debug("Completed shutdown");
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putCleanup(ClassPath key, Cleanup cleanup) {
        this.cleanups.put(key, cleanup);
    }
}

