/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.util.CollectionUtils;

public class DefaultBuildConfigurationActionExecuter
implements BuildConfigurationActionExecuter {
    private final List<BuildConfigurationAction> configurationActions;
    private List<? extends BuildConfigurationAction> taskSelectors;

    public DefaultBuildConfigurationActionExecuter(Iterable<? extends BuildConfigurationAction> configurationActions, Iterable<? extends BuildConfigurationAction> defaultTaskSelectors) {
        this.taskSelectors = Lists.newArrayList(defaultTaskSelectors);
        this.configurationActions = Lists.newArrayList(configurationActions);
    }

    @Override
    public void select(GradleInternal gradle) {
        List processingBuildActions = CollectionUtils.flattenCollections(BuildConfigurationAction.class, (Object[])new Object[]{this.configurationActions, this.taskSelectors});
        this.configure(processingBuildActions, gradle, 0);
    }

    @Override
    public void setTaskSelectors(List<? extends BuildConfigurationAction> taskSelectors) {
        this.taskSelectors = taskSelectors;
    }

    private void configure(final List<BuildConfigurationAction> processingConfigurationActions, final GradleInternal gradle, final int index) {
        if (index >= processingConfigurationActions.size()) {
            return;
        }
        processingConfigurationActions.get(index).configure(new BuildExecutionContext(){

            @Override
            public GradleInternal getGradle() {
                return gradle;
            }

            @Override
            public void proceed() {
                DefaultBuildConfigurationActionExecuter.this.configure(processingConfigurationActions, gradle, index + 1);
            }
        });
    }
}

