/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.util.GFileUtils;

@Incubating
public class InstallExecutable
extends DefaultTask {
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;
    private final DirectoryProperty installDirectory;
    private final RegularFileProperty executable;
    private final RegularFileProperty installedExecutable;
    private final ConfigurableFileCollection libs;
    private final WorkerLeaseService workerLeaseService;

    @Inject
    public InstallExecutable(WorkerLeaseService workerLeaseService) {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.workerLeaseService = workerLeaseService;
        this.libs = this.getProject().files(new Object[0]);
        this.installDirectory = this.newOutputDirectory();
        this.installedExecutable = this.newOutputFile();
        this.installedExecutable.set(this.getLibDirectory().map((Transformer)new Transformer<RegularFile, Directory>(){

            public RegularFile transform(Directory directory) {
                return directory.file(((File)InstallExecutable.this.executable.getAsFile().get()).getName());
            }
        }));
        this.executable = this.newInputFile();
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }

    @Internal(value="Covered by inputFileIfExists")
    public RegularFileProperty getExecutableFile() {
        return this.executable;
    }

    @Internal
    public RegularFileProperty getInstalledExecutable() {
        return this.installedExecutable;
    }

    @SkipWhenEmpty
    @Nullable
    @Optional
    @InputFile
    protected File getInputFileIfExists() {
        RegularFileProperty sourceFile = this.getExecutableFile();
        if (sourceFile.isPresent() && ((RegularFile)sourceFile.get()).getAsFile().exists()) {
            return ((RegularFile)sourceFile.get()).getAsFile();
        }
        return null;
    }

    @InputFiles
    public FileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom((Iterable)libs);
    }

    public void lib(Object libs) {
        this.libs.from(new Object[]{libs});
    }

    @Internal(value="covered by getInstallDirectory")
    public Provider<RegularFile> getRunScriptFile() {
        return this.installDirectory.file(this.executable.map((Transformer)new Transformer<CharSequence, RegularFile>(){

            public CharSequence transform(RegularFile regularFile) {
                OperatingSystem operatingSystem = OperatingSystem.forName((String)((NativePlatform)InstallExecutable.this.targetPlatform.get()).getOperatingSystem().getName());
                return operatingSystem.getScriptName(regularFile.getAsFile().getName());
            }
        }));
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void install() {
        this.workerLeaseService.withoutProjectLock(new Runnable(){

            @Override
            public void run() {
                if (((NativePlatform)InstallExecutable.this.targetPlatform.get()).getOperatingSystem().isWindows()) {
                    InstallExecutable.this.installWindows();
                } else {
                    InstallExecutable.this.installUnix();
                }
            }
        });
    }

    private Provider<Directory> getLibDirectory() {
        return this.getInstallDirectory().dir("lib");
    }

    private void installWindows() {
        File executable = ((RegularFile)this.getExecutableFile().get()).getAsFile();
        this.installToDir(((Directory)this.getLibDirectory().get()).getAsFile());
        StringBuilder toolChainPath = new StringBuilder();
        NativeToolChain toolChain = (NativeToolChain)this.getToolChain().get();
        if (toolChain instanceof Gcc) {
            toolChainPath.append("SET PATH=");
            for (File pathEntry : ((Gcc)toolChain).getPath()) {
                toolChainPath.append(pathEntry.getAbsolutePath()).append(";");
            }
            toolChainPath.append("%PATH%");
        }
        String runScriptText = "\n@echo off\nSETLOCAL\n" + toolChainPath + "\nCALL \"%~dp0lib\\" + executable.getName() + "\" %*" + "\nEXIT /B %ERRORLEVEL%" + "\nENDLOCAL" + "\n";
        GFileUtils.writeFile((String)runScriptText, (File)((RegularFile)this.getRunScriptFile().get()).getAsFile());
    }

    private void installUnix() {
        File destination = ((Directory)this.getInstallDirectory().get()).getAsFile();
        File executable = ((RegularFile)this.getExecutableFile().get()).getAsFile();
        this.installToDir(new File(destination, "lib"));
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nDYLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport DYLD_LIBRARY_PATH\nLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport LD_LIBRARY_PATH\nexec \"$APP_BASE_NAME/lib/" + executable.getName() + "\" \"$@\"" + "\n";
        File runScript = ((RegularFile)this.getRunScriptFile().get()).getAsFile();
        GFileUtils.writeFile((String)runScriptText, (File)runScript);
        this.getFileSystem().chmod(runScript, 493);
    }

    private void installToDir(final File binaryDir) {
        this.getFileOperations().sync((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.into((Object)binaryDir);
                copySpec.from(new Object[]{InstallExecutable.this.getExecutableFile()});
                copySpec.from(new Object[]{InstallExecutable.this.getLibs()});
            }
        });
    }
}

