#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.17
id: lens-4.17-IpPiOSaq8WuDwiOH7KFqYw
key: lens-4.17-IpPiOSaq8WuDwiOH7KFqYw
license: BSD-2-Clause
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
author: Edward A. Kmett
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
abi: a68928848901fd8f80a6b71d3e478505
exposed: True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Coerce Control.Lens.Internal.Context
    Control.Lens.Internal.Deque Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Review
    Control.Lens.Internal.Setter Control.Lens.Internal.TH
    Control.Lens.Internal.Zoom Control.Lens.Iso Control.Lens.Lens
    Control.Lens.Level Control.Lens.Operators Control.Lens.Plated
    Control.Lens.Prism Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Unsound
    Control.Lens.Wrapped Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    Numeric.Natural.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens
hidden-modules: Paths_lens
import-dirs: /usr/lib/ghc-8.4.3/site-local/lens-4.17
library-dirs: /usr/lib/ghc-8.4.3/site-local/lens-4.17
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/lens-4.17
hs-libraries: HSlens-4.17-IpPiOSaq8WuDwiOH7KFqYw
depends:
    array-0.5.2.0 base-4.11.1.0 base-orphans-0.8-3sF6oREckV1L10hzXC2CHH
    bifunctors-5.5.3-Brx4ioiidy0E4oOA1rufI1 bytestring-0.10.8.2
    call-stack-0.1.0-Eiz5FM8yQXpI3vyQ1Rt4Jq
    comonad-5.0.4-DMINZ0aMd8oFIhjlIqJSEs
    contravariant-1.5-5VBqEYOPGpyDW8QIali4BA containers-0.5.11.0
    distributive-0.6-5IIrIvROWijDhzEpafTMUk filepath-1.4.2
    free-5.1-AmXc7IB6NglBkZsDCJJl4I ghc-prim-0.5.2.0
    hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg
    kan-extensions-5.2-JRWujJAKQwkFstT0ZtmjQW
    exceptions-0.10.0-KqLFUMgISLoDmBqq0VbkGc mtl-2.2.2
    parallel-3.2.2.0-E8M4t2NF24XDDNAVbYCukS
    profunctors-5.3-B9XGNPj9eNIFYnD8OF7KYD
    reflection-2.1.4-ET4Qfoy5lmWBopRK3ezJIQ
    semigroupoids-5.3.1-Cs9QoOQ2ldWL3nN4o3Linh
    tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO template-haskell-2.13.0.0
    th-abstraction-0.2.8.0-Ct896m4STpK8GA15Cl5y88 text-1.2.3.0
    transformers-0.5.5.0
    transformers-compat-0.6.2-EZ0ZvADLUlc4V8RuKaJX5W
    unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    void-0.7.2-JAsenjnj1DBHDal2sW0JoW
abi-depends: array-0.5.2.0=dc85b03ee806d784249cc791da6109c3
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             base-orphans-0.8-3sF6oREckV1L10hzXC2CHH=070878b14ffeb7fb78d1dad8024b95cb
             bifunctors-5.5.3-Brx4ioiidy0E4oOA1rufI1=12f884716dc473d98235a4d0de188cc4
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             call-stack-0.1.0-Eiz5FM8yQXpI3vyQ1Rt4Jq=c76ca250c7cf6b5c2ee744c15760c93f
             comonad-5.0.4-DMINZ0aMd8oFIhjlIqJSEs=fef355d343d551e29f05ec96a9889e51
             contravariant-1.5-5VBqEYOPGpyDW8QIali4BA=02e9ed60b8864056c6af15ff76a262ef
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             distributive-0.6-5IIrIvROWijDhzEpafTMUk=c989dcfe9e7c3d052b4dd45341fdc752
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             free-5.1-AmXc7IB6NglBkZsDCJJl4I=bf69e674e600ebf4d8c9b454e446c962
             ghc-prim-0.5.2.0=387aa7e78e4e6c49e51798e4d6763c3f
             hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg=0f14342a1ffe8710d31657335cf81134
             kan-extensions-5.2-JRWujJAKQwkFstT0ZtmjQW=48072feda41fa458805aaa1974330cc8
             exceptions-0.10.0-KqLFUMgISLoDmBqq0VbkGc=7e2a2010d6645bddac83e90b3cee8839
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             parallel-3.2.2.0-E8M4t2NF24XDDNAVbYCukS=bfa6d2c22d7e7c439a84add8c91d8e7a
             profunctors-5.3-B9XGNPj9eNIFYnD8OF7KYD=7d21ce46d9fc7d5c2a62dc0d959da342
             reflection-2.1.4-ET4Qfoy5lmWBopRK3ezJIQ=37ee6153039d91a8a0a308b6c7631d8e
             semigroupoids-5.3.1-Cs9QoOQ2ldWL3nN4o3Linh=9bfc9cb5e6ea7ef0d91007b02ae21fea
             tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO=92d44612a64675b8cba7ce44e507a395
             template-haskell-2.13.0.0=ac7dfd04924d4ebfa90a119ad22a36cc
             th-abstraction-0.2.8.0-Ct896m4STpK8GA15Cl5y88=4938497122b3b44bd39134a6de0cb043
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             transformers-compat-0.6.2-EZ0ZvADLUlc4V8RuKaJX5W=8fe746d31ebcf312c14c2777ca0f137c
             unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd=4d1dd6bd73dbf55dc13ef767664a6e82
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             void-0.7.2-JAsenjnj1DBHDal2sW0JoW=d1de746fbfbe471314dbcb65b5e13ec4
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

