#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.4.0
id: tamarin-prover-theory-1.4.0-Ft6AxIyt3Pi9ECKyWuTRyC
key: tamarin-prover-theory-1.4.0-Ft6AxIyt3Pi9ECKyWuTRyC
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Security protocol types and constraint solver library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
abi: 1c699d17b61092d5271d8095f460228f
exposed: True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.Solver.Types Theory.Constraint.System
    Theory.Constraint.System.Constraints Theory.Constraint.System.Dot
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Rule Theory.Model.Signature
    Theory.Proof Theory.Text.Parser Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness
import-dirs: /usr/lib/ghc-8.4.3/site-local/tamarin-prover-theory-1.4.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/tamarin-prover-theory-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/tamarin-prover-theory-1.4.0
hs-libraries: HStamarin-prover-theory-1.4.0-Ft6AxIyt3Pi9ECKyWuTRyC
depends:
    aeson-1.4.0.0-EgUTCbIlE19378rsR2i9zV
    aeson-pretty-0.8.7-HR98go7is0pARduDbo8oPT base-4.11.1.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.11.0
    deepseq-1.4.3.0 dlist-0.8.0.5-6LWFCfMSEKNIqqazR8mrr6
    fclabels-2.0.3.3-BHaTfJPZDECEU3fkfof1B1 mtl-2.2.2
    parallel-3.2.2.0-E8M4t2NF24XDDNAVbYCukS parsec-3.1.13.0
    process-1.6.3.0 safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur text-1.2.3.0
    transformers-0.5.5.0 uniplate-1.6.12-6qL4xKqlm0u98UwpIwKcfK
    tamarin-prover-utils-1.4.0-KOIDZwQj1LN9Jsz965IzQs
    tamarin-prover-term-1.4.0-9lm9PgEGRztSiBGNrRqD
abi-depends: aeson-1.4.0.0-EgUTCbIlE19378rsR2i9zV=8e4d597de977510ba6167651bfbacc4c
             aeson-pretty-0.8.7-HR98go7is0pARduDbo8oPT=64591c1231c2b75f27f209aa70a0f690
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             dlist-0.8.0.5-6LWFCfMSEKNIqqazR8mrr6=f0c6d817a8f4177a2d0e3837521bb503
             fclabels-2.0.3.3-BHaTfJPZDECEU3fkfof1B1=5a2c9099dd962914d18daf9666ad6fa2
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             parallel-3.2.2.0-E8M4t2NF24XDDNAVbYCukS=bfa6d2c22d7e7c439a84add8c91d8e7a
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             uniplate-1.6.12-6qL4xKqlm0u98UwpIwKcfK=5ce9ecb4c4bd2a035e84875708f762ba
             tamarin-prover-utils-1.4.0-KOIDZwQj1LN9Jsz965IzQs=4fdd1574363055d46df73d4b71c63843
             tamarin-prover-term-1.4.0-9lm9PgEGRztSiBGNrRqD=3b3e90bd489c12ed5e817609c802bee7
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

