/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.support.llvm;

public class SmallPtrSetImplBase
implements Destructors.ClassWithDestructor {
    protected final DenseMapInfo KeyInfo;
    protected type.ptr<Object> SmallArray;
    protected type.ptr<Object> CurArray;
    protected int CurArraySize;
    protected int NumElements;
    protected int NumTombstones;

    protected SmallPtrSetImplBase(type.ptr<Object> SmallStorage, SmallPtrSetImplBase that) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        if (that.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else {
            this.CurArray = std.malloc((int)that.CurArraySize);
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = that.CurArraySize;
        std.memcpy(this.CurArray, that.CurArray, (int)this.CurArraySize);
        this.NumElements = that.NumElements;
        this.NumTombstones = that.NumTombstones;
        this.KeyInfo = that.KeyInfo;
    }

    protected SmallPtrSetImplBase(type.ptr<Object> SmallStorage, int SmallSize, SmallPtrSetImplBase that) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArraySize = that.CurArraySize;
        this.NumElements = that.NumElements;
        this.NumTombstones = that.NumTombstones;
        this.KeyInfo = that.KeyInfo;
        if (that.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            std.memcpy(this.CurArray, that.CurArray, (int)this.CurArraySize);
        } else {
            this.CurArray = (type.ptr)Native.$tryClone(that.CurArray);
            that.CurArray = (type.ptr)Native.$tryClone(that.SmallArray);
        }
        that.CurArraySize = SmallSize;
        assert (Native.$eq_ptr(that.CurArray, that.SmallArray));
        that.NumElements = 0;
        that.NumTombstones = 0;
    }

    protected SmallPtrSetImplBase(DenseMapInfo KeyInfo, type.ptr<Object> SmallStorage, int SmallSize) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArraySize = SmallSize;
        this.KeyInfo = KeyInfo;
        assert (SmallSize != 0 && (SmallSize & SmallSize - 1) == 0) : "Initial size must be a power of two!";
        if (ADTAliases.CHECK_DENSE_MAP_INFO) {
            assert (KeyInfo.getEmptyKey() != KeyInfo.getTombstoneKey()) : "EmptyKey must be different from TombstoneKey:" + KeyInfo;
            assert (!this.$isEqual(KeyInfo.getEmptyKey(), KeyInfo.getTombstoneKey())) : "EmptyKey must be not equal to TombstoneKey:" + KeyInfo;
            assert (KeyInfo.getHashValue(KeyInfo.getEmptyKey()) != KeyInfo.getHashValue(KeyInfo.getTombstoneKey())) : "EmptyKey must have different hashCode to TombstoneKey:" + KeyInfo;
        }
        this.clear();
    }

    public void $destroy() {
        if (!this.isSmall()) {
            std.free(this.CurArray);
        }
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int size() {
        return this.NumElements;
    }

    public void clear() {
        if (!this.isSmall() && Unsigned.$less_uint((int)(this.NumElements * 4), (int)this.CurArraySize) && Unsigned.$greater_uint((int)this.CurArraySize, (int)32)) {
            this.shrink_and_clear();
            return;
        }
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)this.CurArraySize);
        this.NumElements = 0;
        this.NumTombstones = 0;
    }

    protected Object getTombstoneMarker() {
        return this.KeyInfo.getTombstoneKey();
    }

    protected Object getEmptyMarker() {
        return this.KeyInfo.getEmptyKey();
    }

    protected std_pair.pairTypeBool<type.ptr<Object>> insert_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)this.SmallArray.$add(this.NumElements);
            while (Native.$noteq_ptr((void.ptr)APtr, (void.ptr)E)) {
                if (this.$isEqual(APtr.$star(), Ptr)) {
                    return std.make_pair_Ptr_bool((Object)APtr, (boolean)false);
                }
                APtr.$preInc();
            }
            if (Unsigned.$less_uint((int)this.NumElements, (int)this.CurArraySize)) {
                this.SmallArray.$set(this.NumElements++, Ptr);
                return std.make_pair_Ptr_bool((Object)this.SmallArray.$add(this.NumElements - 1), (boolean)true);
            }
        }
        if (built_in.__builtin_expect((int)(Unsigned.$greatereq_uint((int)(this.NumElements * 4), (int)(this.CurArraySize * 3)) ? 1 : 0), (int)0) != 0) {
            this.Grow(Unsigned.$less_uint((int)this.CurArraySize, (int)64) ? 128 : this.CurArraySize * 2);
        } else if (built_in.__builtin_expect((int)(Unsigned.$less_uint((int)(this.CurArraySize - (this.NumElements + this.NumTombstones)), (int)(this.CurArraySize / 8)) ? 1 : 0), (int)0) != 0) {
            this.Grow(this.CurArraySize);
        }
        type.ptr Bucket2 = (type.ptr)Native.$tryClone(this.FindBucketFor(Ptr));
        if (this.$isEqual(Bucket2.$star(), Ptr)) {
            return std.make_pair_Ptr_bool((Object)Bucket2, (boolean)false);
        }
        if (Bucket2.$star() == this.getTombstoneMarker()) {
            --this.NumTombstones;
        }
        Bucket2.$set(this.$cloneIfNeeded(Ptr));
        ++this.NumElements;
        return std.make_pair_Ptr_bool((Object)Bucket2, (boolean)true);
    }

    protected boolean erase_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.SmallArray.$add(this.NumElements));
            while (Native.$noteq_ptr((void.ptr)APtr, (void.ptr)E)) {
                if (this.$isEqual(APtr.$star(), Ptr)) {
                    APtr.$set(E.$at(-1));
                    E.$set(-1, this.getEmptyMarker());
                    --this.NumElements;
                    return true;
                }
                APtr.$preInc();
            }
            return false;
        }
        type.ptr Bucket2 = (type.ptr)Native.$tryClone(this.FindBucketFor(Ptr));
        if (!this.$isEqual(Bucket2.$star(), Ptr)) {
            return false;
        }
        Bucket2.$set(this.getTombstoneMarker());
        --this.NumElements;
        ++this.NumTombstones;
        return true;
    }

    protected boolean count_imp(Object Ptr) {
        if (this.isSmall()) {
            type.ptr APtr = (type.ptr)Native.$tryClone(this.SmallArray);
            type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.SmallArray.$add(this.NumElements));
            while (Native.$noteq_ptr((void.ptr)APtr, (void.ptr)E)) {
                if (this.$isEqual(APtr.$star(), Ptr)) {
                    return true;
                }
                APtr.$preInc();
            }
            return false;
        }
        return this.$isEqual(this.FindBucketFor(Ptr).$star(), Ptr);
    }

    private boolean isSmall() {
        return Native.$eq_ptr(this.CurArray, this.SmallArray);
    }

    private type.ptr<Object> FindBucketFor(Object Ptr) {
        int Bucket2 = this.KeyInfo.getHashValue(Ptr) & this.CurArraySize - 1;
        int ArraySize = this.CurArraySize;
        int ProbeAmt = 1;
        type.ptr Array = (type.ptr)Native.$tryClone(this.CurArray);
        type.ptr Tombstone = null;
        while (built_in.__builtin_expect((int)(Array.$at(Bucket2) == this.getEmptyMarker() ? 1 : 0), (int)1) == 0) {
            if (built_in.__builtin_expect((int)(Native.$eq_ptr((Object)Array.$at(Bucket2), (Object)Ptr) ? 1 : 0), (int)1) != 0) {
                return (type.ptr)Array.$add(Bucket2);
            }
            if (Array.$at(Bucket2) == this.getTombstoneMarker() && Tombstone == null) {
                Tombstone = (type.ptr)Array.$add(Bucket2);
            }
            Bucket2 = Bucket2 + ProbeAmt++ & ArraySize - 1;
        }
        return Tombstone != null ? Tombstone : (type.ptr)Array.$add(Bucket2);
    }

    private void shrink_and_clear() {
        assert (!this.isSmall()) : "Can't shrink a small set!";
        std.free(this.CurArray);
        this.CurArraySize = Unsigned.$greater_uint((int)this.NumElements, (int)16) ? 1 << llvm.Log2_32_Ceil(this.NumElements) + 1 : 32;
        this.NumTombstones = 0;
        this.NumElements = 0;
        this.CurArray = std.malloc((int)this.CurArraySize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)this.CurArraySize);
    }

    private void Grow(int NewSize) {
        int OldSize = this.CurArraySize;
        type.ptr OldBuckets = (type.ptr)Native.$tryClone(this.CurArray);
        boolean WasSmall = this.isSmall();
        this.CurArray = std.malloc((int)NewSize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        this.CurArraySize = NewSize;
        std.memset(this.CurArray, this.KeyInfo.getEmptyKey(), (int)NewSize);
        if (WasSmall) {
            type.ptr BucketPtr = (type.ptr)Native.$tryClone((NativeCloneable)OldBuckets);
            type.ptr E = (type.ptr)OldBuckets.$add(this.NumElements);
            while (Native.$noteq_ptr((void.ptr)BucketPtr, (void.ptr)E)) {
                Object Elt = BucketPtr.$star();
                this.FindBucketFor(Elt).$set(Elt);
                BucketPtr.$preInc();
            }
        } else {
            type.ptr BucketPtr = (type.ptr)Native.$tryClone((NativeCloneable)OldBuckets);
            type.ptr E = (type.ptr)OldBuckets.$add(OldSize);
            while (Native.$noteq_ptr((void.ptr)BucketPtr, (void.ptr)E)) {
                Object Elt = BucketPtr.$star();
                if (Elt != this.getTombstoneMarker() && Elt != this.getEmptyMarker()) {
                    this.FindBucketFor(Elt).$set(Elt);
                }
                BucketPtr.$preInc();
            }
            std.free((Object)OldBuckets);
            this.NumTombstones = 0;
        }
    }

    private void $assign(SmallPtrSetImplBase RHS) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void swap(SmallPtrSetImplBase RHS) {
        if (this == RHS) {
            return;
        }
        if (!this.isSmall() && !RHS.isSmall()) {
            type.ptr<Object> tmpPtr = this.CurArray;
            this.CurArray = RHS.CurArray;
            RHS.CurArray = tmpPtr;
            int tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.NumTombstones;
            this.NumTombstones = RHS.NumTombstones;
            RHS.NumTombstones = tmp;
            return;
        }
        if (!this.isSmall() && RHS.isSmall()) {
            std.copy(RHS.SmallArray, (type.iterator)((type.iterator)RHS.SmallArray.$add(RHS.CurArraySize)), this.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            RHS.CurArray = (type.ptr)Native.$tryClone(this.CurArray);
            RHS.NumTombstones = this.NumTombstones;
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            this.NumTombstones = 0;
            return;
        }
        if (this.isSmall() && !RHS.isSmall()) {
            std.copy(this.SmallArray, (type.iterator)((type.iterator)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            this.CurArray = (type.ptr)Native.$tryClone(RHS.CurArray);
            this.NumTombstones = RHS.NumTombstones;
            RHS.CurArray = (type.ptr)Native.$tryClone(RHS.SmallArray);
            RHS.NumTombstones = 0;
            return;
        }
        assert (this.isSmall() && RHS.isSmall());
        assert (this.CurArraySize == RHS.CurArraySize);
        std.swap_ranges(this.SmallArray, (type.iterator)((type.iterator)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
        int tmp = this.NumElements;
        this.NumElements = RHS.NumElements;
        RHS.NumElements = tmp;
    }

    protected void CopyFrom(SmallPtrSetImplBase RHS) {
        assert (RHS != this) : "Self-copy should be handled by the caller.";
        if (this.isSmall() && RHS.isSmall()) assert (this.CurArraySize == RHS.CurArraySize) : "Cannot assign sets with different small sizes";
        if (RHS.isSmall()) {
            if (!this.isSmall()) {
                std.free(this.CurArray);
            }
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else if (this.CurArraySize != RHS.CurArraySize) {
            if (this.isSmall()) {
                this.CurArray = std.malloc((int)RHS.CurArraySize);
            } else {
                type.ptr T = std.realloc(this.CurArray, (int)this.CurArraySize, (int)RHS.CurArraySize);
                if (T == null) {
                    std.free(this.CurArray);
                }
                this.CurArray = (type.ptr)Native.$tryClone((NativeCloneable)T);
            }
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = RHS.CurArraySize;
        std.memcpy(this.CurArray, RHS.CurArray, (int)this.CurArraySize);
        this.NumElements = RHS.NumElements;
        this.NumTombstones = RHS.NumTombstones;
    }

    protected void MoveFrom(int SmallSize, SmallPtrSetImplBase RHS) {
        assert (RHS != this) : "Self-move should be handled by the caller.";
        if (!this.isSmall()) {
            std.free(this.CurArray);
        }
        if (RHS.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            std.memcpy(this.CurArray, RHS.CurArray, (int)RHS.CurArraySize);
        } else {
            this.CurArray = (type.ptr)Native.$tryClone(RHS.CurArray);
            RHS.CurArray = (type.ptr)Native.$tryClone(RHS.SmallArray);
        }
        this.CurArraySize = RHS.CurArraySize;
        this.NumElements = RHS.NumElements;
        this.NumTombstones = RHS.NumTombstones;
        RHS.CurArraySize = SmallSize;
        assert (Native.$eq_ptr(RHS.CurArray, RHS.SmallArray));
        RHS.NumElements = 0;
        RHS.NumTombstones = 0;
    }

    private Object $cloneIfNeeded(Object Ptr) {
        return Ptr instanceof void.ptr ? Native.$tryClone((Object)Ptr) : Ptr;
    }

    private boolean $isEqual(Object LHS, Object RHS) {
        if (LHS == this.getEmptyMarker()) {
            return LHS == RHS;
        }
        return this.KeyInfo.isEqual(LHS, RHS);
    }

    public String toString() {
        return "SmallArray=" + this.SmallArray + ", CurArray=" + this.CurArray + ", CurArraySize=" + this.CurArraySize + ", NumElements=" + this.NumElements + ", NumTombstones=" + this.NumTombstones;
    }
}

