/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphUI;
import org.netbeans.modules.cnd.callgraph.api.ui.Catalog;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphPanel;
import org.netbeans.modules.cnd.callgraph.impl.DefaultCatalog;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CallGraphTopComponent
extends TopComponent {
    private static CallGraphTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/callgraph/resources/call_graph.png";
    private static final String PREFERRED_ID = "CallGraphTopComponent";
    private JPopupMenu pop;
    private PopupListener listener;
    private CloseListener closeL;
    private Catalog catalog = new DefaultCatalog();
    private JButton jButton1;

    private CallGraphTopComponent() {
        this.initComponents();
        this.setName(this.getMessage("CTL_CallGraphTopComponent"));
        this.setToolTipText(this.getMessage("HINT_CallGraphTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.listener = new PopupListener();
        this.closeL = new CloseListener();
        this.setFocusCycleRoot(true);
    }

    String getMessage(String key) {
        return this.catalog.getMessage(key, new Object[0]);
    }

    public void setModel(CallModel model, CallGraphUI graphUI) {
        CallGraphPanel panel = new CallGraphPanel(graphUI);
        this.catalog = graphUI == null || graphUI.getCatalog() == null ? new DefaultCatalog() : graphUI.getCatalog();
        this.setName(this.getMessage("CTL_CallGraphTopComponent"));
        this.setToolTipText(this.getMessage("HINT_CallGraphTopComponent"));
        panel.setName(model.getName());
        panel.setToolTipText(panel.getName() + " - " + this.getMessage("CTL_CallGraphTopComponent"));
        this.addTabPanel(panel);
        panel.setModel(model);
        panel.requestFocusInWindow();
    }

    void addPanel(JPanel panel) {
        this.setName(panel.getToolTipText());
        this.removeAll();
        this.add(panel, "Center");
        this.validate();
    }

    void addTabPanel(JPanel panel) {
        if (this.getComponentCount() == 0) {
            this.add(panel, "Center");
        } else {
            Component comp = this.getComponent(0);
            if (comp instanceof JTabbedPane) {
                ((JTabbedPane)comp).addTab(panel.getName() + "  ", null, panel, panel.getToolTipText());
                ((JTabbedPane)comp).setSelectedComponent(panel);
                comp.validate();
            } else if (comp instanceof JButton) {
                this.setName(panel.getToolTipText());
                this.remove(comp);
                this.add(panel, "Center");
            } else {
                this.setName(this.getMessage("CTL_CallGraphTopComponent"));
                this.remove(comp);
                JTabbedPane pane = TabbedPaneFactory.createCloseButtonTabbedPane();
                pane.addMouseListener((MouseListener)((Object)this.listener));
                pane.addPropertyChangeListener(this.closeL);
                this.add(pane, "Center");
                pane.addTab(comp.getName() + "  ", null, comp, ((JPanel)comp).getToolTipText());
                pane.addTab(panel.getName() + "  ", null, panel, panel.getToolTipText());
                pane.setSelectedComponent(panel);
                pane.validate();
            }
        }
        this.validate();
        this.requestActive();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(CallGraphTopComponent.class, (String)"NO_VIEW_AVAILABLE"));
        this.jButton1.setEnabled(false);
        this.jButton1.setFocusable(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized CallGraphTopComponent getDefault() {
        if (instance == null) {
            instance = new CallGraphTopComponent();
        }
        return instance;
    }

    public static synchronized CallGraphTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CallGraphTopComponent.class.getName()).warning("Cannot find CallGraphTopComponent component. It will not be located properly in the window system.");
            return CallGraphTopComponent.getDefault();
        }
        if (win instanceof CallGraphTopComponent) {
            return (CallGraphTopComponent)win;
        }
        Logger.getLogger(CallGraphTopComponent.class.getName()).warning("There seem to be multiple components with the 'CallGraphTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CallGraphTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    protected void componentActivated() {
        super.componentActivated();
        this.requestActive();
    }

    public void requestActive() {
        super.requestActive();
        CallGraphPanel graph = this.getCurrentCallGraphPanel();
        if (graph != null) {
            graph.requestFocus();
            graph.requestFocusInWindow();
        }
    }

    private CallGraphPanel getCurrentCallGraphPanel() {
        Component comp;
        if (this.getComponentCount() > 0 && ((comp = this.getComponent(0)) instanceof JTabbedPane ? (comp = ((JTabbedPane)comp).getSelectedComponent()) instanceof CallGraphPanel : comp instanceof CallGraphPanel)) {
            return (CallGraphPanel)comp;
        }
        return null;
    }

    public void componentClosed() {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)comp;
            Component[] c = pane.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof CallGraphPanel)) continue;
                this.removePanel((CallGraphPanel)c[i]);
            }
        } else if (comp instanceof CallGraphPanel) {
            this.removePanel((CallGraphPanel)comp);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void removePanel(JPanel panel) {
        Component comp;
        Component component = comp = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (comp instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)comp;
            if (panel == null) {
                panel = (JPanel)tabs.getSelectedComponent();
            }
            tabs.remove(panel);
            if (tabs.getComponentCount() == 1) {
                Component c = tabs.getComponent(0);
                tabs.removeMouseListener((MouseListener)((Object)this.listener));
                tabs.removePropertyChangeListener(this.closeL);
                this.remove(tabs);
                this.add(c, "Center");
                this.setName(((JPanel)c).getToolTipText());
            }
        } else if (comp instanceof CallGraphPanel) {
            this.remove(comp);
            this.add(this.jButton1, "Center");
            this.setName(this.getMessage("CTL_CallGraphTopComponent"));
            this.close();
        } else {
            this.close();
        }
        this.validate();
    }

    private void closeAllButCurrent() {
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)comp;
            Component current = tabs.getSelectedComponent();
            Component[] c = tabs.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == current || !(c[i] instanceof CallGraphPanel)) continue;
                this.removePanel((CallGraphPanel)c[i]);
            }
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(CallGraphTopComponent.this.getMessage("LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphTopComponent.this.closeAllButCurrent();
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(CallGraphTopComponent.this.getMessage("LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphTopComponent.this.close();
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(CallGraphTopComponent.this.getMessage("LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphTopComponent.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            CallGraphTopComponent.this.pop.show((Component)((Object)CallGraphTopComponent.this), e.getX(), e.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                CallGraphTopComponent.this.removePanel((JPanel)evt.getNewValue());
            }
        }
    }

    private static class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ResolvableHelper() {
        }

        public Object readResolve() {
            return CallGraphTopComponent.getDefault();
        }
    }
}

