/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client.subpanels;

import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KerberosConfigPanel
extends JPanel {
    private WSDLComponent comp;
    private Project project = null;
    private boolean inSync = false;
    String servicePrincipal = null;
    String loginModule = null;
    boolean credentialDelegation = false;
    private JCheckBox credDelegationChBox;
    private JComboBox loginModuleCombo;
    private JLabel loginModuleLabel;
    private JTextField servicePrincipalField;
    private JLabel servicePrincipalLabel;

    public KerberosConfigPanel(WSDLComponent comp, Project p) {
        this.comp = comp;
        this.project = p;
        this.initComponents();
        this.sync();
    }

    private String getLoginModule() {
        return (String)this.loginModuleCombo.getSelectedItem();
    }

    private void setLoginModule(String alias) {
        this.loginModuleCombo.setSelectedItem(alias);
    }

    private String getServicePrincipal() {
        return String.valueOf(this.servicePrincipalField.getText());
    }

    private void setServicePrincipal(String principal) {
        this.servicePrincipalField.setText(principal);
    }

    public void sync() {
        this.inSync = true;
        this.servicePrincipal = ProprietarySecurityPolicyModelHelper.getServicePrincipal(this.comp);
        if (this.servicePrincipal != null) {
            this.setServicePrincipal(this.servicePrincipal);
        }
        this.loginModule = ProprietarySecurityPolicyModelHelper.getLoginModule(this.comp);
        if (this.loginModule != null) {
            this.setLoginModule(this.loginModule);
        }
        this.credentialDelegation = ProprietarySecurityPolicyModelHelper.isCredentialDelegation(this.comp);
        this.setChBox(this.credDelegationChBox, this.credentialDelegation);
        this.inSync = false;
    }

    public void storeState() {
        this.loginModule = this.getLoginModule();
        if (this.loginModule == null || this.loginModule.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setLoginModule(this.comp, null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setLoginModule(this.comp, this.loginModule, true);
        }
        this.servicePrincipal = this.getServicePrincipal();
        if (this.servicePrincipal == null || this.servicePrincipal.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setServicePrincipal(this.comp, null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setServicePrincipal(this.comp, this.servicePrincipal, true);
        }
        this.credentialDelegation = this.getChBox(this.credDelegationChBox);
        ProprietarySecurityPolicyModelHelper.setCredentialDelegation(this.comp, this.credentialDelegation, true);
    }

    public Boolean getChBox(JCheckBox chBox) {
        if (chBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    private void initComponents() {
        this.servicePrincipalLabel = new JLabel();
        this.loginModuleLabel = new JLabel();
        this.loginModuleCombo = new JComboBox();
        this.credDelegationChBox = new JCheckBox();
        this.servicePrincipalField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.servicePrincipalLabel, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosConfigPanel_ServicePrincipal"));
        Mnemonics.setLocalizedText((JLabel)this.loginModuleLabel, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosConfigPanel_LoginModule"));
        this.loginModuleCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.credDelegationChBox, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosPanel_CredentialDelegation"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginModuleLabel).addGroup(layout.createSequentialGroup().addComponent(this.servicePrincipalLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.servicePrincipalField, -2, -1, -2).addComponent(this.loginModuleCombo, 0, 171, Short.MAX_VALUE))).addComponent(this.credDelegationChBox)).addContainerGap()));
        layout.linkSize(0, this.loginModuleCombo, this.servicePrincipalField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginModuleLabel).addComponent(this.loginModuleCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.servicePrincipalLabel).addComponent(this.servicePrincipalField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credDelegationChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.loginModuleCombo, this.servicePrincipalField);
    }
}

