/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SenderVouches;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wizard.SamlCallbackCreator;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;

public class SenderVouchesProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    private static final String PKGNAME = "samlcb";

    @Override
    public int getId() {
        return 70;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_SAMLSENDER;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_SAMLSENDER_INFO;
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        SenderVouches profConfigPanel = new SenderVouches(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public boolean isProfileSupported(Project p, WSDLComponent component, boolean sts) {
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(component);
        return !ConfigVersion.CONFIG_1_0.equals((Object)configVersion);
    }

    @Override
    public void setClientDefaults(WSDLComponent component, WSDLComponent serviceBinding, Project p) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)component);
        String storeLoc = ServerUtils.getStoreLocation(p, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, storeLoc, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", false, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), false, true);
        String tstoreLoc = ServerUtils.getStoreLocation(p, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, tstoreLoc, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", true, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), true, true);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(component, "xws-security-client", true);
        ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(component, "xws-security-server", true);
        FileObject targetFolder = null;
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            targetFolder = sourceGroups[0].getRootFolder();
        }
        SamlCallbackCreator samlCreator = new SamlCallbackCreator();
        String samlVersion = this.getSamlVersion((Binding)serviceBinding);
        String cbName = "SamlCallbackHandler";
        if (targetFolder != null) {
            if (targetFolder.getFileObject(PKGNAME) == null) {
                try {
                    targetFolder = targetFolder.createFolder(PKGNAME);
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, null, ex);
                }
            } else {
                targetFolder = targetFolder.getFileObject(PKGNAME);
            }
            if (ComboConstants.SAML_V2011.equals(samlVersion)) {
                cbName = "Saml20SVCallbackHandler";
                if (targetFolder.getFileObject(cbName, "java") == null) {
                    samlCreator.generateSamlCBHandler(targetFolder, cbName, "sv", "20");
                }
            } else {
                cbName = "Saml11SVCallbackHandler";
                if (targetFolder.getFileObject(cbName, "java") == null) {
                    samlCreator.generateSamlCBHandler(targetFolder, cbName, "sv", "11");
                }
            }
        }
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)component, "samlHandler", "samlcb." + cbName, null, true);
    }

    @Override
    public void setServiceDefaults(WSDLComponent component, Project p) {
        ProprietarySecurityPolicyModelHelper.clearValidators(component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, false);
        String storeLoc = ServerUtils.getStoreLocation(p, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, storeLoc, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", false, false);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, DefaultSettings.getDefaultPassword(p), false, false);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(component, "xws-security-server", false);
    }

    @Override
    public boolean isServiceDefaultSetupUsed(WSDLComponent component, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        return Util.isEqual(DefaultSettings.getDefaultPassword(p), keyPasswd) && Util.isEqual(ServerUtils.getStoreLocation(p, false, false), keyLoc) && Util.isEqual("xws-security-server", keyAlias);
    }

    @Override
    public boolean isClientDefaultSetupUsed(WSDLComponent component, Binding serviceBinding, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String samlVersion = this.getSamlVersion(serviceBinding);
        String cbName = null;
        cbName = ComboConstants.SAML_V2011.equals(samlVersion) ? "Saml20SVCallbackHandler" : "Saml11SVCallbackHandler";
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String trustAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, true);
        String trustLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, true);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        String trustPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, true);
        String cbHandler = ProprietarySecurityPolicyModelHelper.getCallbackHandler((Binding)component, "samlHandler");
        return Util.isEqual("samlcb." + cbName, cbHandler) && Util.isEqual("xws-security-client", keyAlias) && Util.isEqual("xws-security-server", trustAlias) && Util.isEqual(DefaultSettings.getDefaultPassword(p), keyPasswd) && Util.isEqual(DefaultSettings.getDefaultPassword(p), trustPasswd) && Util.isEqual(ServerUtils.getStoreLocation(p, true, true), trustLoc) && Util.isEqual(ServerUtils.getStoreLocation(p, false, false), keyLoc);
    }

    private String getSamlVersion(Binding serviceBinding) {
        ConfigVersion cfgVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)serviceBinding);
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement((WSDLComponent)serviceBinding);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        int suppTokenType = 5;
        if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
            suppTokenType = 1;
        }
        WSDLComponent tokenKind = null;
        boolean secConv = protToken instanceof SecureConversationToken;
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            Policy pp = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
            tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, suppTokenType);
        } else {
            tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)serviceBinding, suppTokenType);
        }
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        return SecurityTokensModelHelper.getTokenProfileVersion(token);
    }

    @Override
    public boolean isSecureConversation(WSDLComponent component) {
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(component);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        return protToken instanceof SecureConversationToken;
    }

    @Override
    public void enableSecureConversation(WSDLComponent component, boolean enable) {
        ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(component)).setSecureConversation(component, enable);
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return true;
    }
}

